/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor.element;

import java.util.List;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.fragment.FragmentAndTarget;
import org.thymeleaf.processor.IElementNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.element.AbstractElementProcessor;

public abstract class AbstractFragmentHandlingElementProcessor
extends AbstractElementProcessor {
    public AbstractFragmentHandlingElementProcessor(String elementName) {
        super(elementName);
    }

    public AbstractFragmentHandlingElementProcessor(IElementNameProcessorMatcher matcher) {
        super(matcher);
    }

    public final ProcessorResult processElement(Arguments arguments, Element element) {
        boolean substituteInclusionNode = this.getSubstituteInclusionNode(arguments, element);
        FragmentAndTarget fragmentAndTarget = this.getFragmentAndTarget(arguments, element, substituteInclusionNode);
        List<Node> fragmentNodes = fragmentAndTarget.extractFragment(arguments.getConfiguration(), arguments, arguments.getTemplateRepository());
        if (fragmentNodes == null) {
            throw new TemplateProcessingException("Cannot correctly process \"" + element.getOriginalName() + "\" element. " + "Fragment specification matched null.");
        }
        element.clearChildren();
        if (substituteInclusionNode) {
            element.setChildren(fragmentNodes);
            element.getParent().extractChild(element);
        } else {
            for (Node fragmentNode : fragmentNodes) {
                element.addChild(fragmentNode);
            }
        }
        this.doAdditionalElementProcessing(arguments, element);
        return ProcessorResult.OK;
    }

    protected abstract boolean getSubstituteInclusionNode(Arguments var1, Element var2);

    protected abstract FragmentAndTarget getFragmentAndTarget(Arguments var1, Element var2, boolean var3);

    protected void doAdditionalElementProcessing(Arguments arguments, Element element) {
    }
}

