/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor.element;

import java.util.HashMap;
import java.util.List;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.NestableNode;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.processor.IElementNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.element.AbstractElementProcessor;
import org.thymeleaf.util.ObjectUtils;
import org.thymeleaf.util.Validate;

public abstract class AbstractIterationElementProcessor
extends AbstractElementProcessor {
    public static String DEFAULT_STATUS_VAR_SUFFIX = "Stat";

    public AbstractIterationElementProcessor(String elementName) {
        super(elementName);
    }

    public AbstractIterationElementProcessor(IElementNameProcessorMatcher matcher) {
        super(matcher);
    }

    public final ProcessorResult processElement(Arguments arguments, Element element) {
        NestableNode parentNode = element.getParent();
        IterationSpec iterationSpec = this.getIterationSpec(arguments, element);
        boolean removeHostIterationElement = this.removeHostIterationElement(arguments, element);
        String iteratedElementName = this.getIteratedElementName(arguments, element);
        String iterVar = iterationSpec.getIterVarName();
        String statusVar = iterationSpec.getStatusVarName();
        Object iteratedObject = iterationSpec.getIteratedObject();
        List<Object> list = ObjectUtils.convertToIterable(iteratedObject);
        int size = list.size();
        int index = 0;
        for (Object obj : list) {
            Element iterElement = null;
            if (removeHostIterationElement) {
                iterElement = (Element)element.cloneNode(parentNode, false);
            } else {
                if (iteratedElementName == null) {
                    throw new TemplateProcessingException("Cannot specify null iterated element name if the host iteration element is not being removed");
                }
                iterElement = element.cloneElementNodeWithNewName(parentNode, iteratedElementName, false);
            }
            parentNode.insertBefore(element, iterElement);
            HashMap<String, Object> nodeLocalVariables = new HashMap<String, Object>();
            nodeLocalVariables.put(iterVar, obj);
            StatusVar status = new StatusVar(index, index + 1, size, obj);
            if (statusVar != null) {
                nodeLocalVariables.put(statusVar, status);
            } else {
                nodeLocalVariables.put(iterVar + DEFAULT_STATUS_VAR_SUFFIX, status);
            }
            if (removeHostIterationElement) {
                List<Node> children = iterElement.getChildren();
                for (Node child : children) {
                    child.setAllNodeLocalVariables(nodeLocalVariables);
                }
                parentNode.extractChild(iterElement);
            } else {
                iterElement.setAllNodeLocalVariables(nodeLocalVariables);
                this.processClonedHostIterationElement(arguments, iterElement);
            }
            ++index;
        }
        parentNode.removeChild(element);
        return ProcessorResult.OK;
    }

    protected abstract IterationSpec getIterationSpec(Arguments var1, Element var2);

    protected abstract boolean removeHostIterationElement(Arguments var1, Element var2);

    protected abstract String getIteratedElementName(Arguments var1, Element var2);

    protected abstract void processClonedHostIterationElement(Arguments var1, Element var2);

    protected static class IterationSpec {
        private final String iterVarName;
        private final String statusVarName;
        private final Object iteratedObject;

        public IterationSpec(String iterVarName, String statusVarName, Object iteratedObject) {
            Validate.notEmpty(iterVarName, "Iteration var name cannot be null or empty");
            this.iterVarName = iterVarName;
            this.statusVarName = statusVarName;
            this.iteratedObject = iteratedObject;
        }

        public String getIterVarName() {
            return this.iterVarName;
        }

        public String getStatusVarName() {
            return this.statusVarName;
        }

        public Object getIteratedObject() {
            return this.iteratedObject;
        }
    }

    public static class StatusVar {
        private final int index;
        private final int count;
        private final int size;
        private final Object current;

        public StatusVar(int index, int count, int size, Object current) {
            this.index = index;
            this.count = count;
            this.size = size;
            this.current = current;
        }

        public int getIndex() {
            return this.index;
        }

        public int getCount() {
            return this.count;
        }

        public int getSize() {
            return this.size;
        }

        public Object getCurrent() {
            return this.current;
        }

        public boolean isEven() {
            return this.index % 2 == 0;
        }

        public boolean isOdd() {
            return !this.isEven();
        }

        public boolean isFirst() {
            return this.index == 0;
        }

        public boolean isLast() {
            return this.index == this.count - 1;
        }

        public String toString() {
            return "{index = " + this.index + ", count = " + this.count + ", size = " + this.size + ", current = " + (this.current == null ? "null" : this.current.toString()) + "}";
        }
    }
}

