/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor.text;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.dom.AbstractTextNode;
import org.thymeleaf.dom.Node;
import org.thymeleaf.processor.AbstractProcessor;
import org.thymeleaf.processor.IProcessorMatcher;
import org.thymeleaf.processor.ITextNodeProcessorMatcher;
import org.thymeleaf.processor.ProcessorMatchingContext;
import org.thymeleaf.processor.ProcessorResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTextNodeProcessor
extends AbstractProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ITextNodeProcessorMatcher matcher;

    public AbstractTextNodeProcessor(ITextNodeProcessorMatcher matcher) {
        this.matcher = matcher;
    }

    public final IProcessorMatcher<? extends AbstractTextNode> getMatcher() {
        return this.matcher;
    }

    @Override
    protected final ProcessorResult doProcess(Arguments arguments, ProcessorMatchingContext processorMatchingContext, Node node) {
        if (this.logger.isTraceEnabled()) {
            String content = ((AbstractTextNode)node).getContent();
            this.logger.trace("[THYMELEAF][{}][{}] Processing text node of type \"{}\" with content \"{}\"", new Object[]{TemplateEngine.threadIndex(), arguments.getTemplateName(), node.getClass().getSimpleName(), content});
        }
        return this.processTextNode(arguments, (AbstractTextNode)node);
    }

    protected abstract ProcessorResult processTextNode(Arguments var1, AbstractTextNode var2);
}

