/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.thymeleaf.standard.expression.ComplexExpression;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.ExpressionParsingNode;
import org.thymeleaf.standard.expression.SimpleExpression;
import org.thymeleaf.standard.expression.Token;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Assignation
implements Serializable {
    private static final long serialVersionUID = -20278893925937213L;
    private static final char ASSIGNATION_CHAR = '=';
    private final Token left;
    private final Expression right;

    private Assignation(Token left, Expression right) {
        Validate.notNull(left, "Assignation left side cannot be null");
        Validate.notNull(right, "Assignation right side cannot be null");
        this.left = left;
        this.right = right;
    }

    private Assignation(Token left) {
        Validate.notNull(left, "Assignation left side cannot be null");
        this.left = left;
        this.right = null;
    }

    public Token getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    public String getStringRepresentation() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(this.left.getStringRepresentation());
        if (this.right != null) {
            strBuilder.append('=');
            if (this.right instanceof ComplexExpression) {
                strBuilder.append('(');
                strBuilder.append(this.right.getStringRepresentation());
                strBuilder.append(')');
            } else {
                strBuilder.append(this.right.getStringRepresentation());
            }
        }
        return strBuilder.toString();
    }

    public String toString() {
        return this.getStringRepresentation();
    }

    static List<ExpressionParsingNode> composeAssignation(List<ExpressionParsingNode> inputExprs, int inputIndex, boolean allowParametersWithoutValue) {
        if (inputExprs == null || inputExprs.size() == 0 || inputIndex >= inputExprs.size()) {
            return null;
        }
        String input = inputExprs.get(inputIndex).getInput();
        StringBuilder inputWithPlaceholders = new StringBuilder();
        StringBuilder fragment = new StringBuilder();
        ArrayList<ExpressionParsingNode> fragments = new ArrayList<ExpressionParsingNode>();
        int tokenIndex = inputExprs.size();
        Token token = null;
        int inputLen = input.length();
        for (int i = 0; i < inputLen; ++i) {
            char c = input.charAt(i);
            if (c == '=' && token == null) {
                inputWithPlaceholders.append('\u00a7');
                inputWithPlaceholders.append(String.valueOf(tokenIndex));
                inputWithPlaceholders.append('\u00a7');
                token = Token.parse(fragment.toString());
                if (token == null) {
                    return null;
                }
                fragments.add(new ExpressionParsingNode(token));
                fragment = new StringBuilder();
                continue;
            }
            fragment.append(c);
        }
        if (token == null) {
            if (allowParametersWithoutValue) {
                inputWithPlaceholders.append('\u00a7');
                inputWithPlaceholders.append(String.valueOf(tokenIndex));
                inputWithPlaceholders.append('\u00a7');
                token = Token.parse(fragment.toString());
                if (token == null) {
                    return null;
                }
                fragments.add(new ExpressionParsingNode(token));
                fragment = null;
            } else {
                return null;
            }
        }
        int expressionIndex = -1;
        if (fragment != null) {
            expressionIndex = tokenIndex + 1;
            inputWithPlaceholders.append('=');
            inputWithPlaceholders.append('\u00a7');
            inputWithPlaceholders.append(String.valueOf(expressionIndex));
            inputWithPlaceholders.append('\u00a7');
            fragments.add(new ExpressionParsingNode(fragment.toString()));
        }
        List<ExpressionParsingNode> result = inputExprs;
        result.set(inputIndex, new ExpressionParsingNode(inputWithPlaceholders.toString()));
        result.addAll(fragments);
        if (expressionIndex != -1) {
            if ((result = SimpleExpression.addNumberLiteralDecomposition(result, expressionIndex)) == null) {
                return null;
            }
            if ((result = Expression.unnest(result, expressionIndex)) == null) {
                return null;
            }
            if (!result.get(expressionIndex).isExpression()) {
                if ((result = ComplexExpression.composeComplexExpressions(result, expressionIndex)) == null) {
                    return null;
                }
                if (!result.get(expressionIndex).isExpression()) {
                    return null;
                }
            }
            Assignation assignation = new Assignation(token, result.get(expressionIndex).getExpression());
            result.set(inputIndex, new ExpressionParsingNode(assignation));
        } else {
            Assignation assignation = new Assignation(token);
            result.set(inputIndex, new ExpressionParsingNode(assignation));
        }
        return result;
    }
}

