/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Configuration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.standard.expression.ComplexExpression;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.ExpressionParsingNode;
import org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultExpression
extends ComplexExpression {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExpression.class);
    private static final long serialVersionUID = 1830867943963082362L;
    private static final String DEFAULT_OPERATOR = "?:";
    private final Expression queriedExpression;
    private final Expression defaultExpression;

    public DefaultExpression(Expression queriedExpression, Expression defaultExpression) {
        Validate.notNull(queriedExpression, "Queried expression cannot be null");
        Validate.notNull(defaultExpression, "Default expression cannot be null");
        this.queriedExpression = queriedExpression;
        this.defaultExpression = defaultExpression;
    }

    public Expression getQueriedExpression() {
        return this.queriedExpression;
    }

    public Expression getDefaultExpression() {
        return this.defaultExpression;
    }

    @Override
    public String getStringRepresentation() {
        StringBuilder sb = new StringBuilder();
        if (this.queriedExpression instanceof ComplexExpression) {
            sb.append('(');
            sb.append(this.queriedExpression);
            sb.append(')');
        } else {
            sb.append(this.queriedExpression);
        }
        sb.append(' ');
        sb.append(DEFAULT_OPERATOR);
        sb.append(' ');
        if (this.defaultExpression instanceof ComplexExpression) {
            sb.append('(');
            sb.append(this.defaultExpression);
            sb.append(')');
        } else {
            sb.append(this.defaultExpression);
        }
        return sb.toString();
    }

    static List<ExpressionParsingNode> composeDefaultExpression(List<ExpressionParsingNode> decomposition, int inputIndex) {
        ExpressionParsingNode inputParsingNode = decomposition.get(inputIndex);
        List<ExpressionParsingNode> result = decomposition;
        String input = inputParsingNode.getInput();
        if (input == null || input.trim().equals("")) {
            return null;
        }
        int defaultOperatorPos = input.indexOf(DEFAULT_OPERATOR);
        if (defaultOperatorPos == -1) {
            return result;
        }
        String queriedStr = input.substring(0, defaultOperatorPos);
        String defaultStr = input.substring(defaultOperatorPos + 2);
        if (defaultStr.indexOf(DEFAULT_OPERATOR) != -1) {
            return null;
        }
        int queriedIndex = Expression.placeHolderToIndex(queriedStr);
        if (queriedIndex == -1) {
            List<ExpressionParsingNode> newResult = new ArrayList<ExpressionParsingNode>(result);
            queriedIndex = newResult.size();
            newResult.add(new ExpressionParsingNode(queriedStr));
            newResult = ComplexExpression.composeComplexExpressions(newResult, queriedIndex);
            if (newResult == null) {
                return null;
            }
            result = newResult;
        } else if ((result = ComplexExpression.composeComplexExpressions(result, queriedIndex)) == null) {
            return null;
        }
        int defaultIndex = Expression.placeHolderToIndex(defaultStr);
        if (defaultIndex == -1) {
            List<ExpressionParsingNode> newResult = new ArrayList<ExpressionParsingNode>(result);
            defaultIndex = newResult.size();
            newResult.add(new ExpressionParsingNode(defaultStr));
            newResult = ComplexExpression.composeComplexExpressions(newResult, defaultIndex);
            if (newResult == null) {
                return null;
            }
            result = newResult;
        } else if ((result = ComplexExpression.composeComplexExpressions(result, defaultIndex)) == null) {
            return null;
        }
        ExpressionParsingNode queriedEPN = result.get(queriedIndex);
        Expression queriedExpr = queriedEPN.getExpression();
        if (queriedExpr == null) {
            return null;
        }
        ExpressionParsingNode defaultEPN = result.get(defaultIndex);
        Expression defaultExpr = defaultEPN.getExpression();
        if (defaultExpr == null) {
            return null;
        }
        DefaultExpression defaultExpressionResult = new DefaultExpression(queriedExpr, defaultExpr);
        result.set(inputIndex, new ExpressionParsingNode(defaultExpressionResult));
        return result;
    }

    static Object executeDefault(Configuration configuration, IProcessingContext processingContext, DefaultExpression expression, IStandardVariableExpressionEvaluator expressionEvaluator) {
        Object queriedValue;
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating default expression: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        if ((queriedValue = Expression.execute(configuration, processingContext, expression.getQueriedExpression(), expressionEvaluator)) == null) {
            return Expression.execute(configuration, processingContext, expression.getDefaultExpression(), expressionEvaluator);
        }
        return queriedValue;
    }
}

