/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.Token;
import org.thymeleaf.util.Validate;

public final class Each
implements Serializable {
    private static final long serialVersionUID = -4085690403057997591L;
    private static final Pattern EACH_PATTERN = Pattern.compile("^\\s*(.*?)\\s*(?:,\\s*(.+?)\\s*)?\\:\\s*(.+?)\\s*$", 32);
    private final Token iterVar;
    private final Token statusVar;
    private final Expression iterable;

    private Each(Token iterVar, Token statusVar, Expression iterable) {
        Validate.notNull(iterVar, "Iteration variable cannot be null");
        Validate.notNull(iterable, "Iterable cannot be null");
        this.iterVar = iterVar;
        this.statusVar = statusVar;
        this.iterable = iterable;
    }

    public Token getIterVar() {
        return this.iterVar;
    }

    public boolean hasStatusVar() {
        return this.statusVar != null && !this.statusVar.getValue().trim().equals("");
    }

    public Token getStatusVar() {
        return this.statusVar;
    }

    public Expression getIterable() {
        return this.iterable;
    }

    public String getStringRepresentation() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.iterVar);
        if (this.hasStatusVar()) {
            sb.append(',');
            sb.append(this.statusVar);
        }
        sb.append(" : ");
        sb.append(this.iterable);
        return sb.toString();
    }

    public String toString() {
        return this.getStringRepresentation();
    }

    static Each parse(String input) {
        if (input == null || input.trim().equals("")) {
            return null;
        }
        String trimmedInput = input.trim();
        Matcher matcher = EACH_PATTERN.matcher(trimmedInput);
        if (!matcher.matches()) {
            return null;
        }
        String iterVar = matcher.group(1);
        String statusVar = matcher.group(2);
        String iterable = matcher.group(3);
        if (iterVar == null || iterVar.trim().equals("")) {
            return null;
        }
        if (iterable == null || iterable.trim().equals("")) {
            return null;
        }
        Expression iterableExpression = Expression.parse(iterable);
        if (iterableExpression == null) {
            return null;
        }
        Token iterVarToken = Token.parse(iterVar);
        if (iterVarToken == null) {
            return null;
        }
        Each each = null;
        if (statusVar != null && !statusVar.trim().equals("")) {
            Token statusVarToken = Token.parse(statusVar);
            if (statusVarToken == null) {
                return null;
            }
            each = new Each(iterVarToken, statusVarToken, iterableExpression);
        } else {
            each = new Each(iterVarToken, null, iterableExpression);
        }
        return each;
    }
}

