/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import org.thymeleaf.Configuration;
import org.thymeleaf.cache.ICache;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.standard.expression.AssignationSequence;
import org.thymeleaf.standard.expression.Each;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.ExpressionSequence;
import org.thymeleaf.standard.expression.FragmentSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ExpressionCache {
    private static final String EXPRESSION_CACHE_PREFIX = "{expression}";
    private static final String ASSIGNATION_SEQUENCE_CACHE_PREFIX = "{assignation_sequence}";
    private static final String EXPRESSION_SEQUENCE_CACHE_PREFIX = "{expression_sequence}";
    private static final String EACH_CACHE_PREFIX = "{each}";
    private static final String FRAGMENT_SELECTION_CACHE_PREFIX = "{fragment_selection}";

    ExpressionCache() {
    }

    private static Object getFromCache(Configuration configuration, String input, String prefix) {
        ICache<String, Object> cache;
        ICacheManager cacheManager = configuration.getCacheManager();
        if (cacheManager != null && (cache = cacheManager.getExpressionCache()) != null) {
            return cache.get(prefix + input);
        }
        return null;
    }

    private static <V> void putIntoCache(Configuration configuration, String input, V value, String prefix) {
        ICache<String, Object> cache;
        ICacheManager cacheManager = configuration.getCacheManager();
        if (cacheManager != null && (cache = cacheManager.getExpressionCache()) != null) {
            cache.put(prefix + input, value);
        }
    }

    Expression getExpressionFromCache(Configuration configuration, String input) {
        return (Expression)ExpressionCache.getFromCache(configuration, input, EXPRESSION_CACHE_PREFIX);
    }

    void putExpressionIntoCache(Configuration configuration, String input, Expression value) {
        ExpressionCache.putIntoCache(configuration, input, value, EXPRESSION_CACHE_PREFIX);
    }

    AssignationSequence getAssignationSequenceFromCache(Configuration configuration, String input) {
        return (AssignationSequence)ExpressionCache.getFromCache(configuration, input, ASSIGNATION_SEQUENCE_CACHE_PREFIX);
    }

    void putAssignationSequenceIntoCache(Configuration configuration, String input, AssignationSequence value) {
        ExpressionCache.putIntoCache(configuration, input, value, ASSIGNATION_SEQUENCE_CACHE_PREFIX);
    }

    ExpressionSequence getExpressionSequenceFromCache(Configuration configuration, String input) {
        return (ExpressionSequence)ExpressionCache.getFromCache(configuration, input, EXPRESSION_SEQUENCE_CACHE_PREFIX);
    }

    void putExpressionSequenceIntoCache(Configuration configuration, String input, ExpressionSequence value) {
        ExpressionCache.putIntoCache(configuration, input, value, EXPRESSION_SEQUENCE_CACHE_PREFIX);
    }

    Each getEachFromCache(Configuration configuration, String input) {
        return (Each)ExpressionCache.getFromCache(configuration, input, EACH_CACHE_PREFIX);
    }

    void putEachIntoCache(Configuration configuration, String input, Each value) {
        ExpressionCache.putIntoCache(configuration, input, value, EACH_CACHE_PREFIX);
    }

    FragmentSelection getFragmentSelectionFromCache(Configuration configuration, String input) {
        return (FragmentSelection)ExpressionCache.getFromCache(configuration, input, FRAGMENT_SELECTION_CACHE_PREFIX);
    }

    void putFragmentSelectionIntoCache(Configuration configuration, String input, FragmentSelection value) {
        ExpressionCache.putIntoCache(configuration, input, value, FRAGMENT_SELECTION_CACHE_PREFIX);
    }
}

