/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.io.Serializable;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.TextLiteralExpression;
import org.thymeleaf.util.Validate;

public final class FragmentSelection
implements Serializable {
    private static final long serialVersionUID = -5310313871594922690L;
    private static final String FRAGMENT_SEPARATOR = "::";
    private static final char FRAGMENT_SELECTOR_XPATH_START = '[';
    private static final char FRAGMENT_SELECTOR_XPATH_END = ']';
    private final Expression templateName;
    private final Expression fragmentSelector;
    private final boolean isXPath;

    private FragmentSelection(Expression templateName) {
        Validate.notNull(templateName, "Template name cannot be null");
        this.templateName = templateName;
        this.fragmentSelector = null;
        this.isXPath = false;
    }

    private FragmentSelection(Expression templateName, Expression fragmentSelector, boolean isXPath) {
        Validate.notNull(templateName, "Template name cannot be null");
        Validate.notNull(fragmentSelector, "Fragment selector cannot be null");
        this.templateName = templateName;
        this.fragmentSelector = fragmentSelector;
        this.isXPath = isXPath;
    }

    public Expression getTemplateName() {
        return this.templateName;
    }

    public Expression getFragmentSelector() {
        return this.fragmentSelector;
    }

    public boolean hasFragmentSelector() {
        return this.fragmentSelector != null;
    }

    public boolean isXPath() {
        return this.isXPath;
    }

    public String getStringRepresentation() {
        if (this.fragmentSelector == null) {
            return this.templateName.getStringRepresentation();
        }
        if (this.isXPath) {
            return this.templateName.getStringRepresentation() + " " + FRAGMENT_SEPARATOR + " " + String.valueOf('[') + this.fragmentSelector.getStringRepresentation() + String.valueOf(']');
        }
        return this.templateName.getStringRepresentation() + " " + FRAGMENT_SEPARATOR + " " + this.fragmentSelector.getStringRepresentation();
    }

    public String toString() {
        return this.getStringRepresentation();
    }

    static FragmentSelection parse(String input) {
        if (input == null || input.trim().equals("")) {
            return null;
        }
        String trimmedInput = input.trim();
        int separatorPos = trimmedInput.lastIndexOf(FRAGMENT_SEPARATOR);
        if (separatorPos == -1) {
            Expression templateNameExpr = FragmentSelection.getExpressionDefaultToLiteral(trimmedInput);
            if (templateNameExpr == null) {
                return null;
            }
            FragmentSelection fragmentSelection = new FragmentSelection(templateNameExpr);
            return fragmentSelection;
        }
        String templateName = trimmedInput.substring(0, separatorPos).trim();
        String fragmentSelector = trimmedInput.substring(separatorPos + 2).trim();
        if (fragmentSelector.equals("") || templateName.equals("")) {
            return null;
        }
        boolean xpath = false;
        if (fragmentSelector.length() > 2 && fragmentSelector.charAt(0) == '[' && fragmentSelector.charAt(fragmentSelector.length() - 1) == ']') {
            fragmentSelector = fragmentSelector.substring(1, fragmentSelector.length() - 1).trim();
            xpath = true;
        }
        Expression templateNameExpr = FragmentSelection.getExpressionDefaultToLiteral(templateName);
        Expression fragmentSelectorExpr = FragmentSelection.getExpressionDefaultToLiteral(fragmentSelector);
        if (templateNameExpr == null || fragmentSelectorExpr == null) {
            return null;
        }
        FragmentSelection fragmentSelection = new FragmentSelection(templateNameExpr, fragmentSelectorExpr, xpath);
        return fragmentSelection;
    }

    private static Expression getExpressionDefaultToLiteral(String valueStr) {
        Expression expr = Expression.parse(valueStr);
        if (expr == null) {
            return TextLiteralExpression.parseTextLiteral(valueStr);
        }
        return expr;
    }
}

