/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.standard.expression.LiteralValue;
import org.thymeleaf.standard.expression.SimpleExpression;
import org.thymeleaf.util.Validate;

public final class TextLiteralExpression
extends SimpleExpression {
    private static final Logger logger = LoggerFactory.getLogger(TextLiteralExpression.class);
    private static final long serialVersionUID = 6511847028638506552L;
    static final char DELIMITER = '\'';
    private static final Pattern DELIMITER_ESCAPE_PATTERN = Pattern.compile("\\\\'");
    private final LiteralValue value;

    public TextLiteralExpression(String value) {
        Validate.notNull(value, "Value cannot be null");
        this.value = new LiteralValue(TextLiteralExpression.unwrapLiteral(value));
    }

    public LiteralValue getValue() {
        return this.value;
    }

    private static String unwrapLiteral(String input) {
        int inputLen = input.length();
        if (inputLen > 1 && input.charAt(0) == '\'' && input.charAt(inputLen - 1) == '\'') {
            String unwrappedInput = input.substring(1, inputLen - 1);
            return DELIMITER_ESCAPE_PATTERN.matcher(unwrappedInput).replaceAll("'");
        }
        return input;
    }

    public String getStringRepresentation() {
        return String.valueOf('\'') + this.value.getValue().replace(String.valueOf('\''), "\\'") + String.valueOf('\'');
    }

    static TextLiteralExpression parseTextLiteral(String input) {
        return new TextLiteralExpression(input);
    }

    static Object executeTextLiteral(IProcessingContext processingContext, TextLiteralExpression expression) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating text literal: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        return expression.getValue();
    }
}

