/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.processor.attr;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.attr.AbstractAttributeModifierAttrProcessor;
import org.thymeleaf.standard.expression.Assignation;
import org.thymeleaf.standard.expression.AssignationSequence;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.StandardExpressionProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStandardAttributeModifierAttrProcessor
extends AbstractAttributeModifierAttrProcessor {
    public AbstractStandardAttributeModifierAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        super(matcher);
    }

    public AbstractStandardAttributeModifierAttrProcessor(String attributeName) {
        super(attributeName);
    }

    @Override
    protected final Map<String, String> getModifiedAttributeValues(Arguments arguments, Element element, String attributeName) {
        String attributeValue = element.getAttributeValue(attributeName);
        AssignationSequence assignations = StandardExpressionProcessor.parseAssignationSequence(arguments, attributeValue, false);
        if (assignations == null) {
            throw new TemplateProcessingException("Could not parse value as attribute assignations: \"" + attributeValue + "\"");
        }
        HashMap<String, String> newAttributeValues = new HashMap<String, String>(assignations.size() + 1, 1.0f);
        for (Assignation assignation : assignations) {
            String newAttributeName = assignation.getLeft().getValue();
            Expression expression = assignation.getRight();
            Object result = StandardExpressionProcessor.executeExpression(arguments, expression);
            newAttributeValues.put(newAttributeName, result == null ? "" : result.toString());
        }
        return Collections.unmodifiableMap(newAttributeValues);
    }

    @Override
    protected boolean recomputeProcessorsAfterExecution(Arguments arguments, Element element, String attributeName) {
        return false;
    }
}

