/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.processor.attr;

import java.util.HashMap;
import java.util.Map;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.attr.AbstractLocalVariableDefinitionAttrProcessor;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.StandardExpressionProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStandardSwitchStructureAttrProcessor
extends AbstractLocalVariableDefinitionAttrProcessor {
    public static final String SWITCH_VARIABLE_NAME = "[%SWITCH_EXPR%]";

    public AbstractStandardSwitchStructureAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        super(matcher);
    }

    public AbstractStandardSwitchStructureAttrProcessor(String attributeName) {
        super(attributeName);
    }

    @Override
    protected final Map<String, Object> getNewLocalVariables(Arguments arguments, Element element, String attributeName) {
        String attributeValue = element.getAttributeValue(attributeName);
        Expression switchExpression = StandardExpressionProcessor.parseExpression(arguments, attributeValue);
        HashMap<String, Object> newVariables = new HashMap<String, Object>();
        newVariables.put(SWITCH_VARIABLE_NAME, new SwitchStructure(switchExpression));
        return newVariables;
    }

    public static final class SwitchStructure {
        private final Expression expression;
        private boolean executed;

        public SwitchStructure(Expression expression) {
            this.expression = expression;
            this.executed = false;
        }

        public Expression getExpression() {
            return this.expression;
        }

        public boolean isExecuted() {
            return this.executed;
        }

        public void setExecuted(boolean executed) {
            this.executed = executed;
        }
    }
}

