/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.thymeleaf.util.NumberPointType;
import org.thymeleaf.util.Validate;

public final class NumberUtils {
    public static String format(Number target, Integer minIntegerDigits, Locale locale) {
        Validate.notNull(target, "Cannot apply format on null");
        Validate.notNull(minIntegerDigits, "Minimum integer digits cannot be null");
        return NumberUtils.formatNumber(target, minIntegerDigits, NumberPointType.NONE, 0, NumberPointType.NONE, locale);
    }

    public static String format(Number target, Integer minIntegerDigits, NumberPointType thousandsPointType, Locale locale) {
        Validate.notNull(target, "Cannot apply format on null");
        Validate.notNull(minIntegerDigits, "Minimum integer digits cannot be null");
        Validate.notNull((Object)thousandsPointType, "Thousands point type cannot be null");
        return NumberUtils.formatNumber(target, minIntegerDigits, thousandsPointType, 0, NumberPointType.NONE, locale);
    }

    public static String format(Number target, Integer minIntegerDigits, Integer decimalDigits, Locale locale) {
        Validate.notNull(target, "Cannot apply format on null");
        Validate.notNull(minIntegerDigits, "Minimum integer digits cannot be null");
        Validate.notNull(decimalDigits, "Decimal digits cannot be null");
        return NumberUtils.formatNumber(target, minIntegerDigits, NumberPointType.NONE, decimalDigits, NumberPointType.DEFAULT, locale);
    }

    public static String format(Number target, Integer minIntegerDigits, Integer decimalDigits, NumberPointType decimalPointType, Locale locale) {
        Validate.notNull(target, "Cannot apply format on null");
        Validate.notNull(minIntegerDigits, "Minimum integer digits cannot be null");
        Validate.notNull(decimalDigits, "Decimal digits cannot be null");
        Validate.notNull((Object)decimalPointType, "Decimal point type cannot be null");
        return NumberUtils.formatNumber(target, minIntegerDigits, NumberPointType.NONE, decimalDigits, decimalPointType, locale);
    }

    public static String format(Number target, Integer minIntegerDigits, NumberPointType thousandsPointType, Integer decimalDigits, Locale locale) {
        Validate.notNull(target, "Cannot apply format on null");
        Validate.notNull(minIntegerDigits, "Minimum integer digits cannot be null");
        Validate.notNull((Object)thousandsPointType, "Thousands point type cannot be null");
        Validate.notNull(decimalDigits, "Decimal digits cannot be null");
        return NumberUtils.formatNumber(target, minIntegerDigits, thousandsPointType, decimalDigits, NumberPointType.DEFAULT, locale);
    }

    public static String format(Number target, Integer minIntegerDigits, NumberPointType thousandsPointType, Integer decimalDigits, NumberPointType decimalPointType, Locale locale) {
        Validate.notNull(target, "Cannot apply format on null");
        Validate.notNull(minIntegerDigits, "Minimum integer digits cannot be null");
        Validate.notNull((Object)thousandsPointType, "Thousands point type cannot be null");
        Validate.notNull(decimalDigits, "Decimal digits cannot be null");
        Validate.notNull((Object)decimalPointType, "Decimal point type cannot be null");
        return NumberUtils.formatNumber(target, minIntegerDigits, thousandsPointType, decimalDigits, decimalPointType, locale);
    }

    public static Integer[] sequence(Integer from, Integer to) {
        return NumberUtils.sequence(from, to, 1);
    }

    public static Integer[] sequence(Integer from, Integer to, Integer step) {
        Validate.notNull(from, "Value to start the sequence from cannot be null");
        Validate.notNull(to, "Value to generate the sequence up to cannot be null");
        Validate.notNull(step, "Step to generate the sequence cannot be null");
        int iFrom = from;
        int iTo = to;
        int iStep = step;
        if (iFrom == iTo) {
            return new Integer[]{iFrom};
        }
        ArrayList<Integer> values = new ArrayList<Integer>();
        if (iFrom < iTo) {
            for (int i = iFrom; i <= iTo; i += iStep) {
                values.add(i);
            }
        } else {
            for (int i = iFrom; i >= iTo; i -= iStep) {
                values.add(i);
            }
        }
        return values.toArray(new Integer[values.size()]);
    }

    private static String formatNumber(Number target, Integer minIntegerDigits, NumberPointType thousandsPointType, Integer fractionDigits, NumberPointType decimalPointType, Locale locale) {
        Validate.notNull(target, "Cannot apply format on null");
        Validate.notNull(fractionDigits, "Fraction digits cannot be null");
        Validate.notNull((Object)decimalPointType, "Decimal point type cannot be null");
        Validate.notNull((Object)thousandsPointType, "Thousands point type cannot be null");
        Validate.notNull(locale, "Locale cannot be null");
        DecimalFormat format = null;
        if (target instanceof Double || target instanceof Float || target instanceof BigDecimal || target instanceof Integer || target instanceof Long || target instanceof Byte || target instanceof Short || target instanceof BigInteger) {
            format = (DecimalFormat)NumberFormat.getNumberInstance();
            format.setMinimumFractionDigits(fractionDigits);
            format.setMaximumFractionDigits(fractionDigits);
            if (minIntegerDigits != null) {
                format.setMinimumIntegerDigits(minIntegerDigits);
            }
        } else {
            throw new IllegalArgumentException("Cannot format object of class \"" + target.getClass().getName() + "\" as a decimal number");
        }
        format.setDecimalSeparatorAlwaysShown(decimalPointType != NumberPointType.NONE && fractionDigits > 0);
        format.setGroupingUsed(thousandsPointType != NumberPointType.NONE);
        format.setDecimalFormatSymbols(NumberUtils.computeDecimalFormatSymbols(decimalPointType, thousandsPointType, locale));
        return format.format(target);
    }

    private static DecimalFormatSymbols computeDecimalFormatSymbols(NumberPointType decimalPointType, NumberPointType thousandsPointType, Locale locale) {
        DecimalFormatSymbols dfs;
        Validate.notNull((Object)decimalPointType, "Decimal point type cannot be null");
        Validate.notNull((Object)thousandsPointType, "Thousands point type cannot be null");
        Validate.notNull(locale, "Locale cannot be null");
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
        switch (decimalPointType) {
            case POINT: {
                symbols.setDecimalSeparator('.');
                break;
            }
            case COMMA: {
                symbols.setDecimalSeparator(',');
                break;
            }
            case DEFAULT: {
                dfs = new DecimalFormatSymbols(locale);
                symbols.setDecimalSeparator(dfs.getDecimalSeparator());
                break;
            }
            case NONE: {
                symbols.setDecimalSeparator('?');
            }
        }
        switch (thousandsPointType) {
            case POINT: {
                symbols.setGroupingSeparator('.');
                break;
            }
            case COMMA: {
                symbols.setGroupingSeparator(',');
                break;
            }
            case DEFAULT: {
                dfs = new DecimalFormatSymbols(locale);
                symbols.setGroupingSeparator(dfs.getGroupingSeparator());
                break;
            }
            case NONE: {
                symbols.setGroupingSeparator('?');
            }
        }
        return symbols;
    }

    private NumberUtils() {
    }
}

