/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.PublicSubkeyPacket;
import org.bouncycastle.bcpg.SecretKeyPacket;
import org.bouncycastle.bcpg.SecretSubkeyPacket;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;

public class PGPSecretKeyRing
extends PGPKeyRing {
    List keys;
    List extraPubKeys;

    PGPSecretKeyRing(List list) {
        this(list, new ArrayList());
    }

    private PGPSecretKeyRing(List list, List list2) {
        this.keys = list;
        this.extraPubKeys = list2;
    }

    public PGPSecretKeyRing(byte[] byArray) throws IOException, PGPException {
        this(new ByteArrayInputStream(byArray));
    }

    public PGPSecretKeyRing(byte[] byArray, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException, PGPException {
        this(new ByteArrayInputStream(byArray), keyFingerPrintCalculator);
    }

    public PGPSecretKeyRing(InputStream inputStream) throws IOException, PGPException {
        this(inputStream, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
    }

    public PGPSecretKeyRing(InputStream inputStream, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException, PGPException {
        this.keys = new ArrayList();
        this.extraPubKeys = new ArrayList();
        BCPGInputStream bCPGInputStream = PGPSecretKeyRing.wrap(inputStream);
        int n = bCPGInputStream.nextPacketTag();
        if (n != 5 && n != 7) {
            throw new IOException("secret key ring doesn't start with secret key tag: tag 0x" + Integer.toHexString(n));
        }
        SecretKeyPacket secretKeyPacket = (SecretKeyPacket)bCPGInputStream.readPacket();
        while (bCPGInputStream.nextPacketTag() == 61) {
            bCPGInputStream.readPacket();
        }
        TrustPacket trustPacket = PGPSecretKeyRing.readOptionalTrustPacket(bCPGInputStream);
        List list = PGPSecretKeyRing.readSignaturesAndTrust(bCPGInputStream);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        PGPSecretKeyRing.readUserIDs(bCPGInputStream, arrayList, arrayList2, arrayList3);
        this.keys.add(new PGPSecretKey(secretKeyPacket, new PGPPublicKey(secretKeyPacket.getPublicKeyPacket(), trustPacket, list, arrayList, arrayList2, arrayList3, keyFingerPrintCalculator)));
        while (bCPGInputStream.nextPacketTag() == 7 || bCPGInputStream.nextPacketTag() == 14) {
            List list2;
            TrustPacket trustPacket2;
            ContainedPacket containedPacket;
            if (bCPGInputStream.nextPacketTag() == 7) {
                containedPacket = (SecretSubkeyPacket)bCPGInputStream.readPacket();
                while (bCPGInputStream.nextPacketTag() == 61) {
                    bCPGInputStream.readPacket();
                }
                trustPacket2 = PGPSecretKeyRing.readOptionalTrustPacket(bCPGInputStream);
                list2 = PGPSecretKeyRing.readSignaturesAndTrust(bCPGInputStream);
                this.keys.add(new PGPSecretKey((SecretKeyPacket)containedPacket, new PGPPublicKey(((SecretKeyPacket)containedPacket).getPublicKeyPacket(), trustPacket2, list2, keyFingerPrintCalculator)));
                continue;
            }
            containedPacket = (PublicSubkeyPacket)bCPGInputStream.readPacket();
            trustPacket2 = PGPSecretKeyRing.readOptionalTrustPacket(bCPGInputStream);
            list2 = PGPSecretKeyRing.readSignaturesAndTrust(bCPGInputStream);
            this.extraPubKeys.add(new PGPPublicKey((PublicKeyPacket)containedPacket, trustPacket2, list2, keyFingerPrintCalculator));
        }
    }

    public PGPPublicKey getPublicKey() {
        return ((PGPSecretKey)this.keys.get(0)).getPublicKey();
    }

    public PGPPublicKey getPublicKey(long l) {
        PGPSecretKey pGPSecretKey = this.getSecretKey(l);
        if (pGPSecretKey != null) {
            return pGPSecretKey.getPublicKey();
        }
        for (int i = 0; i != this.extraPubKeys.size(); ++i) {
            PGPPublicKey pGPPublicKey = (PGPPublicKey)this.keys.get(i);
            if (l != pGPPublicKey.getKeyID()) continue;
            return pGPPublicKey;
        }
        return null;
    }

    public Iterator getPublicKeys() {
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>();
        Iterator iterator = this.getSecretKeys();
        while (iterator.hasNext()) {
            arrayList.add(((PGPSecretKey)iterator.next()).getPublicKey());
        }
        arrayList.addAll(this.extraPubKeys);
        return Collections.unmodifiableList(arrayList).iterator();
    }

    public PGPSecretKey getSecretKey() {
        return (PGPSecretKey)this.keys.get(0);
    }

    public Iterator getSecretKeys() {
        return Collections.unmodifiableList(this.keys).iterator();
    }

    public PGPSecretKey getSecretKey(long l) {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPSecretKey pGPSecretKey = (PGPSecretKey)this.keys.get(i);
            if (l != pGPSecretKey.getKeyID()) continue;
            return pGPSecretKey;
        }
        return null;
    }

    public Iterator getExtraPublicKeys() {
        return this.extraPubKeys.iterator();
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(OutputStream outputStream) throws IOException {
        Object object;
        int n;
        for (n = 0; n != this.keys.size(); ++n) {
            object = (PGPSecretKey)this.keys.get(n);
            ((PGPSecretKey)object).encode(outputStream);
        }
        for (n = 0; n != this.extraPubKeys.size(); ++n) {
            object = (PGPPublicKey)this.extraPubKeys.get(n);
            ((PGPPublicKey)object).encode(outputStream);
        }
    }

    public static PGPSecretKeyRing replacePublicKeys(PGPSecretKeyRing pGPSecretKeyRing, PGPPublicKeyRing pGPPublicKeyRing) {
        ArrayList<PGPSecretKey> arrayList = new ArrayList<PGPSecretKey>(pGPSecretKeyRing.keys.size());
        for (PGPSecretKey pGPSecretKey : pGPSecretKeyRing.keys) {
            PGPPublicKey pGPPublicKey = pGPPublicKeyRing.getPublicKey(pGPSecretKey.getKeyID());
            arrayList.add(PGPSecretKey.replacePublicKey(pGPSecretKey, pGPPublicKey));
        }
        return new PGPSecretKeyRing(arrayList);
    }

    public static PGPSecretKeyRing copyWithNewPassword(PGPSecretKeyRing pGPSecretKeyRing, char[] cArray, char[] cArray2, int n, SecureRandom secureRandom, String string) throws PGPException, NoSuchProviderException {
        return PGPSecretKeyRing.copyWithNewPassword(pGPSecretKeyRing, cArray, cArray2, n, secureRandom, PGPUtil.getProvider(string));
    }

    public static PGPSecretKeyRing copyWithNewPassword(PGPSecretKeyRing pGPSecretKeyRing, char[] cArray, char[] cArray2, int n, SecureRandom secureRandom, Provider provider) throws PGPException {
        ArrayList<PGPSecretKey> arrayList = new ArrayList<PGPSecretKey>(pGPSecretKeyRing.keys.size());
        Iterator iterator = pGPSecretKeyRing.getSecretKeys();
        while (iterator.hasNext()) {
            arrayList.add(PGPSecretKey.copyWithNewPassword((PGPSecretKey)iterator.next(), cArray, cArray2, n, secureRandom, provider));
        }
        return new PGPSecretKeyRing(arrayList, pGPSecretKeyRing.extraPubKeys);
    }

    public static PGPSecretKeyRing insertSecretKey(PGPSecretKeyRing pGPSecretKeyRing, PGPSecretKey pGPSecretKey) {
        ArrayList<PGPSecretKey> arrayList = new ArrayList<PGPSecretKey>(pGPSecretKeyRing.keys);
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i != arrayList.size(); ++i) {
            PGPSecretKey pGPSecretKey2 = (PGPSecretKey)arrayList.get(i);
            if (pGPSecretKey2.getKeyID() == pGPSecretKey.getKeyID()) {
                bl = true;
                arrayList.set(i, pGPSecretKey);
            }
            if (!pGPSecretKey2.isMasterKey()) continue;
            bl2 = true;
        }
        if (!bl) {
            if (pGPSecretKey.isMasterKey()) {
                if (bl2) {
                    throw new IllegalArgumentException("cannot add a master key to a ring that already has one");
                }
                arrayList.add(0, pGPSecretKey);
            } else {
                arrayList.add(pGPSecretKey);
            }
        }
        return new PGPSecretKeyRing(arrayList, pGPSecretKeyRing.extraPubKeys);
    }

    public static PGPSecretKeyRing removeSecretKey(PGPSecretKeyRing pGPSecretKeyRing, PGPSecretKey pGPSecretKey) {
        ArrayList arrayList = new ArrayList(pGPSecretKeyRing.keys);
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            PGPSecretKey pGPSecretKey2 = (PGPSecretKey)arrayList.get(i);
            if (pGPSecretKey2.getKeyID() != pGPSecretKey.getKeyID()) continue;
            bl = true;
            arrayList.remove(i);
        }
        if (!bl) {
            return null;
        }
        return new PGPSecretKeyRing(arrayList, pGPSecretKeyRing.extraPubKeys);
    }
}

