/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import org.bouncycastle.jcajce.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.JcaJceHelper;
import org.bouncycastle.jcajce.NamedJcaJceHelper;
import org.bouncycastle.jcajce.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.openpgp.operator.jcajce.PGPUtil;
import org.bouncycastle.openpgp.operator.jcajce.SHA1PGPDigestCalculator;

public class JcePBESecretKeyEncryptorBuilder {
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private int encAlgorithm;
    private PGPDigestCalculator s2kDigestCalculator;
    private SecureRandom random;

    public JcePBESecretKeyEncryptorBuilder(int n) {
        this(n, new SHA1PGPDigestCalculator());
    }

    public JcePBESecretKeyEncryptorBuilder(int n, PGPDigestCalculator pGPDigestCalculator) {
        this.encAlgorithm = n;
        this.s2kDigestCalculator = pGPDigestCalculator;
    }

    public JcePBESecretKeyEncryptorBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcePBESecretKeyEncryptorBuilder setProvider(String string) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(string));
        return this;
    }

    public JcePBESecretKeyEncryptorBuilder setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public PBESecretKeyEncryptor build(char[] cArray) {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        return new PBESecretKeyEncryptor(this.encAlgorithm, this.s2kDigestCalculator, this.random, cArray){
            private Cipher c;
            private byte[] iv;

            public byte[] encryptKeyData(byte[] byArray, byte[] byArray2, int n, int n2) throws PGPException {
                try {
                    this.c = JcePBESecretKeyEncryptorBuilder.this.helper.createCipher(PGPUtil.getSymmetricCipherName(this.encAlgorithm) + "/CFB/NoPadding");
                    this.c.init(1, (Key)PGPUtil.makeSymmetricKey(this.encAlgorithm, byArray), this.random);
                    this.iv = this.c.getIV();
                    return this.c.doFinal(byArray2, n, n2);
                }
                catch (IllegalBlockSizeException illegalBlockSizeException) {
                    throw new PGPException("illegal block size: " + illegalBlockSizeException.getMessage(), illegalBlockSizeException);
                }
                catch (BadPaddingException badPaddingException) {
                    throw new PGPException("bad padding: " + badPaddingException.getMessage(), badPaddingException);
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new PGPException("invalid key: " + invalidKeyException.getMessage(), invalidKeyException);
                }
            }

            public byte[] getCipherIV() {
                return this.iv;
            }
        };
    }
}

