/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.connector.signavio;

import org.camunda.bpm.cycle.connector.ConnectorNodeType;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class SignavioJson {
    private static final String JSON_REP_OBJ = "rep";
    private static final String JSON_REL_PROP = "rel";
    private static final String JSON_HREF_PROP = "href";
    private static final String JSON_NAME_PROP = "name";
    private static final String JSON_TITLE_PROP = "title";
    private static final String JSON_PARENT_PROP = "parent";
    private static final String JSON_PARENT_NAME_PROP = "parentName";
    private static final String JSON_TYPE_PROP = "type";
    private static final String JSON_NAMESPACE_PROP = "namespace";
    private static final String JSON_UPDATED_PROP = "updated";
    private static final String JSON_COMMENT_PROP = "comment";
    private static final String JSON_DIR_VALUE = "dir";
    private static final String JSON_MOD_VALUE = "mod";
    private static final String JSON_PRIVATE_VALUE = "private";
    private static final String JSON_TYPE_BPMN20_VALUE = "BPMN 2.0";
    private static final String JSON_NAMESPACE_BPMN20_VALUE = "bpmn2.0";

    public static String extractNodeName(String json) {
        try {
            return SignavioJson.extractNodeName((JSONObject)new JSONObject(json));
        }
        catch (JSONException e) {
            throw new RuntimeException("Unable to extract node name.", e);
        }
    }

    public static String extractNodeName(JSONObject jsonObj) {
        try {
            String label = "";
            JSONObject repJsonObj = jsonObj.getJSONObject("rep");
            if (repJsonObj.has("name")) {
                label = repJsonObj.getString("name");
            } else if (repJsonObj.has("title")) {
                label = repJsonObj.getString("title");
            }
            return label;
        }
        catch (JSONException e) {
            throw new RuntimeException("Unable to extract node name.", e);
        }
    }

    public static String extractDirectoryId(JSONObject jsonObj) {
        try {
            String directoryId = jsonObj.getString("href");
            directoryId = directoryId.replace("/directory", "");
            return directoryId;
        }
        catch (JSONException e) {
            throw new RuntimeException("Unable to extract directory id.", e);
        }
    }

    public static String extractModelId(JSONObject jsonObj) {
        try {
            String directoryId = jsonObj.getString("href");
            directoryId = directoryId.replace("/model", "");
            return directoryId;
        }
        catch (JSONException e) {
            throw new RuntimeException("Unable to extract model id.", e);
        }
    }

    public static ConnectorNodeType extractModelContentType(JSONObject jsonObj) {
        try {
            JSONObject repJsonObj = jsonObj.getJSONObject("rep");
            if (repJsonObj.has("type") && "BPMN 2.0".equals(repJsonObj.getString("type")) || repJsonObj.has("namespace") && repJsonObj.getString("namespace").contains("bpmn2.0")) {
                return ConnectorNodeType.BPMN_FILE;
            }
            return ConnectorNodeType.ANY_FILE;
        }
        catch (JSONException e) {
            throw new RuntimeException("Unable to extract content type.", e);
        }
    }

    public static String extractPrivateFolderId(String json) {
        try {
            JSONArray jsonArray = new JSONArray(json);
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject repJsonObj;
                String type;
                JSONObject jsonObj = jsonArray.getJSONObject(i);
                String rel = jsonObj.getString("rel");
                if (!rel.equals("dir") || !(type = (repJsonObj = jsonObj.getJSONObject("rep")).getString("type")).equals("private")) continue;
                String directoryId = jsonObj.getString("href");
                directoryId = directoryId.replace("/directory", "");
                return directoryId;
            }
            throw new RuntimeException("Unable to determine private folder id");
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to determine private folder id", e);
        }
    }

    public static String extractPrivateFolderName(String json) {
        try {
            JSONArray jsonArray = new JSONArray(json);
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject repJsonObj;
                String type;
                JSONObject jsonObj = jsonArray.getJSONObject(i);
                String rel = jsonObj.getString("rel");
                if (!rel.equals("dir") || !(type = (repJsonObj = jsonObj.getJSONObject("rep")).getString("type")).equals("private")) continue;
                return SignavioJson.extractNodeName((JSONObject)jsonObj);
            }
            throw new RuntimeException("Unable to determine private folder name");
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to determine private folder name", e);
        }
    }

    public static String extractLastModifiedDateFromInfo(String info) {
        try {
            JSONObject jsonObj = new JSONObject(info);
            return jsonObj.getString("updated");
        }
        catch (JSONException e) {
            throw new RuntimeException("Unable to extract last modified date.", e);
        }
    }

    public static String extractParentIdFromInfo(String info) {
        try {
            JSONObject jsonObj = new JSONObject(info);
            return jsonObj.getString("parent").replace("/directory", "");
        }
        catch (JSONException e) {
            throw new RuntimeException("Unable to extract parent id.", e);
        }
    }

    public static String extractParentNameFromInfo(String info) {
        try {
            JSONObject jsonObj = new JSONObject(info);
            return jsonObj.getString("parentName");
        }
        catch (JSONException e) {
            throw new RuntimeException("Unable to extract parent name.", e);
        }
    }

    public static String extractIdForMatchingModelName(String json, String modelName) throws JSONException {
        JSONArray jsonArray = new JSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObj = jsonArray.getJSONObject(i);
            String relProp = jsonObj.getString("rel");
            if (relProp.equals("dir") && SignavioJson.extractNodeName((JSONObject)jsonObj).equals(modelName)) {
                return SignavioJson.extractDirectoryId((JSONObject)jsonObj);
            }
            if (!relProp.equals("mod") || !SignavioJson.extractNodeName((JSONObject)jsonObj).equals(modelName)) continue;
            return SignavioJson.extractModelId((JSONObject)jsonObj);
        }
        throw new RuntimeException("Unable to get id for model named: " + modelName);
    }

    public static String extractModelComment(JSONObject jsonObj) {
        try {
            String comment = "";
            JSONObject repJsonObj = jsonObj.getJSONObject("rep");
            if (repJsonObj.has("comment")) {
                comment = repJsonObj.getString("comment");
            }
            return comment;
        }
        catch (JSONException e) {
            throw new RuntimeException("Unable to extract comment.", e);
        }
    }
}

