/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.web.dto;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.cycle.connector.ConnectorNode;
import org.camunda.bpm.cycle.connector.ConnectorNodeType;

public class ConnectorNodeDTO {
    private String id;
    private String label;
    private ConnectorNodeType type;
    private Long connectorId;

    public ConnectorNodeDTO() {
    }

    public ConnectorNodeDTO(ConnectorNode connectorNode) {
        this.id = connectorNode.getId();
        this.label = connectorNode.getLabel();
        this.type = connectorNode.getType();
        this.connectorId = connectorNode.getConnectorId();
    }

    public ConnectorNodeDTO(String id, String label, long connectorId) {
        this.id = id;
        this.label = label;
        this.connectorId = connectorId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public ConnectorNodeType getType() {
        return this.type;
    }

    public void setType(ConnectorNodeType type) {
        this.type = type;
    }

    public Long getConnectorId() {
        return this.connectorId;
    }

    public void setConnectorId(Long connectorId) {
        this.connectorId = connectorId;
    }

    public ConnectorNode toConnectorNode() {
        return new ConnectorNode(this.id, this.label, this.connectorId, this.type);
    }

    public static List<ConnectorNodeDTO> wrapAll(List<ConnectorNode> nodes) {
        ArrayList<ConnectorNodeDTO> dtos = new ArrayList<ConnectorNodeDTO>();
        for (ConnectorNode tn : nodes) {
            dtos.add(new ConnectorNodeDTO(tn));
        }
        return dtos;
    }
}

