/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.web.dto;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.cycle.entity.BpmnDiagram;
import org.camunda.bpm.cycle.entity.Roundtrip;
import org.camunda.bpm.cycle.web.dto.BpmnDiagramDTO;

public class RoundtripDTO {
    private Long id;
    private String name;
    private BpmnDiagramDTO leftHandSide;
    private BpmnDiagramDTO rightHandSide;
    private Date lastSync;
    private Roundtrip.SyncMode lastSyncMode;

    public RoundtripDTO() {
    }

    public RoundtripDTO(Roundtrip r) {
        this.id = r.getId();
        this.name = r.getName();
        this.lastSync = r.getLastSync();
        this.setLastSyncMode(r.getLastSyncMode());
    }

    public RoundtripDTO(Roundtrip r, BpmnDiagram leftHandSide, BpmnDiagram rightHandSide) {
        this(r);
        this.leftHandSide = leftHandSide != null ? BpmnDiagramDTO.wrap((BpmnDiagram)leftHandSide) : null;
        this.rightHandSide = rightHandSide != null ? BpmnDiagramDTO.wrap((BpmnDiagram)rightHandSide) : null;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getLastSync() {
        return this.lastSync;
    }

    public void setLastSync(Date lastSync) {
        this.lastSync = lastSync;
    }

    public BpmnDiagramDTO getLeftHandSide() {
        return this.leftHandSide;
    }

    public void setLeftHandSide(BpmnDiagramDTO leftHandSide) {
        this.leftHandSide = leftHandSide;
    }

    public BpmnDiagramDTO getRightHandSide() {
        return this.rightHandSide;
    }

    public void setRightHandSide(BpmnDiagramDTO rightHandSide) {
        this.rightHandSide = rightHandSide;
    }

    public static RoundtripDTO wrap(Roundtrip roundtrip) {
        return new RoundtripDTO(roundtrip);
    }

    public static RoundtripDTO wrapIncludeDiagrams(Roundtrip roundtrip) {
        return new RoundtripDTO(roundtrip, roundtrip.getLeftHandSide(), roundtrip.getRightHandSide());
    }

    public static List<RoundtripDTO> wrapAll(List<Roundtrip> trackers) {
        ArrayList<RoundtripDTO> dtos = new ArrayList<RoundtripDTO>();
        for (Roundtrip t : trackers) {
            dtos.add(new RoundtripDTO(t));
        }
        return dtos;
    }

    public Roundtrip.SyncMode getLastSyncMode() {
        return this.lastSyncMode;
    }

    public void setLastSyncMode(Roundtrip.SyncMode lastSyncMode) {
        this.lastSyncMode = lastSyncMode;
    }
}

