/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.web.service.resource;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.camunda.bpm.cycle.connector.Connector;
import org.camunda.bpm.cycle.connector.ConnectorNode;
import org.camunda.bpm.cycle.connector.ConnectorNodeType;
import org.camunda.bpm.cycle.connector.ConnectorRegistry;
import org.camunda.bpm.cycle.connector.ContentInformation;
import org.camunda.bpm.cycle.util.IoUtil;
import org.camunda.bpm.cycle.web.dto.ConnectorDTO;
import org.camunda.bpm.cycle.web.dto.ConnectorNodeDTO;
import org.camunda.bpm.cycle.web.jaxrs.ext.JaxRsUtil;
import org.camunda.bpm.cycle.web.service.AbstractRestService;

@Path(value="secured/resource/connector")
public class ConnectorService
extends AbstractRestService {
    @Inject
    protected ConnectorRegistry connectorRegistry;

    @GET
    @Path(value="list")
    @Produces(value={"application/json"})
    public List<ConnectorDTO> list() {
        ArrayList<ConnectorDTO> result = new ArrayList<ConnectorDTO>();
        for (Connector c : this.connectorRegistry.getConnectors()) {
            result.add(new ConnectorDTO(c));
        }
        return result;
    }

    @GET
    @Path(value="{connectorId}/root")
    @Produces(value={"application/json"})
    public List<ConnectorNodeDTO> root(@PathParam(value="connectorId") long connectorId) {
        Connector connector = this.getConnector(connectorId);
        ArrayList<ConnectorNode> rootList = new ArrayList<ConnectorNode>();
        rootList.add(connector.getRoot());
        return ConnectorNodeDTO.wrapAll(rootList);
    }

    @GET
    @Path(value="{connectorId}/children")
    @Produces(value={"application/json"})
    public List<ConnectorNodeDTO> children(@PathParam(value="connectorId") long connectorId, @QueryParam(value="nodeId") String nodeId, @QueryParam(value="type") List<ConnectorNodeType> connectorNodeTypes) {
        Connector connector = this.getConnector(connectorId);
        List children = connector.getChildren(new ConnectorNode(nodeId));
        Iterator i = children.iterator();
        while (i.hasNext()) {
            ConnectorNode next = (ConnectorNode)i.next();
            if (next.getType().isAnyOf(connectorNodeTypes.toArray(new ConnectorNodeType[0]))) continue;
            i.remove();
        }
        return ConnectorNodeDTO.wrapAll((List)children);
    }

    @Path(value="{connectorId}/contents")
    @Produces(value={"application/xml"})
    public String getXmlContent(@PathParam(value="connectorId") long connectorId, @QueryParam(value="nodeId") String nodeId) {
        Connector connector = this.getConnector(connectorId);
        try {
            return new Scanner(connector.getContent(new ConnectorNode(nodeId))).useDelimiter("\\A").next();
        }
        catch (NoSuchElementException e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{connectorId}/contents")
    public Response getTypedContent(@PathParam(value="connectorId") long connectorId, @QueryParam(value="nodeId") String nodeId, @QueryParam(value="type") ConnectorNodeType type) {
        Connector connector = this.getConnector(connectorId);
        InputStream content = connector.getContent(new ConnectorNode(nodeId, null, type));
        if (content == null) {
            return JaxRsUtil.createResponse().status(Response.Status.NOT_FOUND).build();
        }
        try {
            Response response = JaxRsUtil.createResponse().status(Response.Status.OK).entity((Object)IoUtil.readInputStream((InputStream)content, (String)(connectorId + "-" + nodeId + "-content-stream"))).header("Content-Type", (Object)type.getMimeType()).build();
            return response;
        }
        finally {
            IoUtil.closeSilently((InputStream)content);
        }
    }

    @GET
    @Path(value="{connectorId}/contents/info")
    public ContentInformation getContentInfo(@PathParam(value="connectorId") long connectorId, @QueryParam(value="nodeId") String nodeId, @QueryParam(value="type") @DefaultValue(value="ANY_FILE") ConnectorNodeType type) {
        Connector connector = this.getConnector(connectorId);
        return connector.getContentInformation(new ConnectorNode(nodeId, null, type));
    }

    protected Connector getConnector(long connectorId) {
        Connector connector = this.connectorRegistry.getConnector(connectorId);
        if (connector == null) {
            throw this.notFound("connector not found");
        }
        return connector;
    }
}

