/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.web.service.resource;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.camunda.bpm.cycle.configuration.CycleConfiguration;
import org.camunda.bpm.cycle.connector.crypt.EncryptionService;
import org.camunda.bpm.cycle.entity.AbstractEntity;
import org.camunda.bpm.cycle.entity.User;
import org.camunda.bpm.cycle.repository.UserRepository;
import org.camunda.bpm.cycle.security.IdentityHolder;
import org.camunda.bpm.cycle.service.mail.MailService;
import org.camunda.bpm.cycle.service.mail.MailServiceException;
import org.camunda.bpm.cycle.web.dto.PasswordChangeDTO;
import org.camunda.bpm.cycle.web.dto.UserDTO;
import org.camunda.bpm.cycle.web.service.AbstractRestService;
import org.camunda.bpm.security.UserIdentity;
import org.springframework.transaction.annotation.Transactional;

@Path(value="secured/resource/user")
public class UserService
extends AbstractRestService {
    private Logger log = Logger.getLogger(UserService.class.getName());
    @Inject
    private UserRepository userRepository;
    @Inject
    private MailService mailService;
    @Inject
    private CycleConfiguration configuration;
    @Inject
    private EncryptionService encryptionService;

    @GET
    public List<UserDTO> list() {
        return UserDTO.wrapAll((List)this.userRepository.findAll());
    }

    @GET
    @Path(value="{id}")
    public UserDTO get(@PathParam(value="id") long id) {
        return UserDTO.wrap((User)this.getUserById(id));
    }

    @POST
    @Path(value="{id}")
    @RolesAllowed(value={"admin"})
    @Transactional
    public UserDTO update(UserDTO data) {
        long id = data.getId();
        User user = this.getUserById(id);
        if (user == null) {
            throw this.notFound("user not found");
        }
        this.update(user, data);
        return UserDTO.wrap((User)user);
    }

    @POST
    @RolesAllowed(value={"admin"})
    public UserDTO create(UserDTO data) {
        User user = new User();
        this.update(user, data);
        String sendEmailResult = this.sendWelcomeEmail(user, data.getPassword());
        return UserDTO.wrap((User)((User)this.userRepository.saveAndFlush((AbstractEntity)user)));
    }

    @DELETE
    @Path(value="{id}")
    @RolesAllowed(value={"admin"})
    @Transactional
    public void delete(@PathParam(value="id") long id) {
        User user = this.getUserById(id);
        if (user == null) {
            throw this.notFound("User not found");
        }
        this.userRepository.delete((AbstractEntity)user);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="isNameAvailable")
    public boolean isNameAvailable(@QueryParam(value="name") String name) {
        return this.userRepository.isNameAvailable(name);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="{id}/changePassword")
    @Transactional
    public String changePassword(@PathParam(value="id") long userId, PasswordChangeDTO data) {
        UserIdentity principal = IdentityHolder.getIdentity();
        User user = this.getUserById(userId);
        if (principal != null && principal.getName().equals(user.getName()) && this.encryptionService.checkUserPassword(data.getOldPassword(), user.getPassword())) {
            user.setPassword(this.encryptionService.encryptUserPassword(data.getNewPassword()));
            return "Ok";
        }
        throw this.notAllowed("invalid credentials");
    }

    private void update(User user, UserDTO data) {
        user.setName(data.getName());
        user.setEmail(data.getEmail());
        user.setAdmin(data.isAdmin());
        if (data.getPassword() != null) {
            user.setPassword(this.encryptionService.encryptUserPassword(data.getPassword()));
        }
    }

    protected String sendWelcomeEmail(User user, String password) {
        String emailFrom = this.configuration.getEmailFrom();
        String email = user.getEmail();
        try {
            this.mailService.sendWelcomeEmail(email, password, emailFrom, email);
            return "success";
        }
        catch (MailServiceException e) {
            this.log.log(Level.WARNING, e.getMessage(), e);
            return e.getMessage();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "An unexpected exception occured while trying to send an email", e);
            return "An unexpected exception occured while trying to send an email: " + e.getMessage();
        }
    }

    protected User getUserById(long id) {
        User user = (User)this.userRepository.findById(id);
        if (user == null) {
            throw this.notFound("user not found");
        }
        return user;
    }
}

