/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.connector;

import java.io.Serializable;
import java.util.Date;
import org.camunda.bpm.cycle.connector.ConnectorNodeType;

public class ConnectorNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String id;
    private Long connectorId;
    private String label;
    private Date created;
    private Date lastModified;
    private String message;
    private ConnectorNodeType type = ConnectorNodeType.UNSPECIFIED;

    public ConnectorNode() {
    }

    public ConnectorNode(String id) {
        this.id = id;
    }

    public ConnectorNode(String id, String label) {
        this(id);
        this.label = label;
    }

    public ConnectorNode(String id, ConnectorNodeType type) {
        this(id);
        this.type = type;
    }

    public ConnectorNode(String id, String label, Long connectorId) {
        this(id, label);
        this.connectorId = connectorId;
    }

    public ConnectorNode(String id, String label, Long connectorId, ConnectorNodeType type) {
        this(id, label);
        this.connectorId = connectorId;
        this.type = type;
    }

    public ConnectorNode(String id, String label, ConnectorNodeType type) {
        this(id, label);
        this.type = type;
    }

    public ConnectorNode(String id, String label, Long connectorId, ConnectorNodeType type, String message) {
        this(id, label, connectorId, type);
        this.message = message;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public ConnectorNodeType getType() {
        return this.type;
    }

    public void setType(ConnectorNodeType type) {
        this.type = type;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public Long getConnectorId() {
        return this.connectorId;
    }

    public void setConnectorId(Long connectorId) {
        this.connectorId = connectorId;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectorNode other = (ConnectorNode)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public boolean isDirectory() {
        return this.type != null && this.type.isDirectory();
    }

    public String toString() {
        return "ConnectorNode [id=" + this.id + ", connectorId=" + this.connectorId + ", label=" + this.label + "]";
    }
}

