/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.connector.git;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.camunda.bpm.cycle.connector.Connector;
import org.camunda.bpm.cycle.connector.ConnectorNode;
import org.camunda.bpm.cycle.connector.ConnectorNodeType;
import org.camunda.bpm.cycle.connector.ContentInformation;
import org.camunda.bpm.cycle.connector.Secured;
import org.camunda.bpm.cycle.connector.Threadsafe;
import org.camunda.bpm.cycle.connector.vfs.VfsConnector;
import org.camunda.bpm.cycle.entity.ConnectorConfiguration;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class GitConnector
extends Connector {
    private final Logger log = LoggerFactory.getLogger(GitConnector.class);
    public static final String CONFIG_KEY_REPOSITORY_PATH = "gitRepositoryPath";
    public static final String CONFIG_KEY_BRANCH_NAME = "branchname";
    public static final String DEFAULT_BRANCH_NAME = "cycle";
    protected VfsConnector delegate = null;
    private Git localGit = null;
    private String baseTemporaryFileStore;
    private final Object mutex = new Object();
    protected String username;
    protected String password;
    protected String branch;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ConnectorConfiguration config) {
        if (this.isConnectorDelegateInitialized()) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            String branchNameProperty;
            if (this.isConnectorDelegateInitialized()) {
                return;
            }
            this.log.debug("Initialize Git-Connector ...");
            this.baseTemporaryFileStore = System.getProperty("java.io.tmpdir") + File.separator + "CAMUNDA_GIT_CON_TEMP_" + UUID.randomUUID().toString();
            File tempDir = new File(this.baseTemporaryFileStore);
            if (!tempDir.exists()) {
                tempDir.mkdir();
            }
            if ((branchNameProperty = (String)config.getProperties().get(CONFIG_KEY_BRANCH_NAME)) != null) {
                this.branch = branchNameProperty.trim();
            }
            if (this.branch == null || this.branch.trim().isEmpty()) {
                this.branch = DEFAULT_BRANCH_NAME;
            }
            this.log.debug("branchname was set to default : {}", (Object)this.branch);
            config.getProperties().put("BASE_PATH", this.baseTemporaryFileStore);
            if (this.getConfiguration() == null) {
                this.setConfiguration(config);
            }
            this.delegate = new VfsConnector();
            this.delegate.setConfiguration(config);
            this.delegate.init();
            this.log.debug("GitConnector initialized, Repository will be initialized on first access.");
        }
    }

    @Threadsafe
    @Secured
    public List<ConnectorNode> getChildren(ConnectorNode node) {
        this.pullFromRemote();
        return this.delegate.getChildren(node);
    }

    @Threadsafe
    @Secured
    public InputStream getContent(ConnectorNode node) {
        this.pullFromRemote();
        return this.delegate.getContent(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initRepository() {
        if (this.isRepositoryInitialized()) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.isRepositoryInitialized()) {
                return;
            }
            this.log.debug("Initialize Repository ...");
            Assert.hasText((String)this.username, (String)"The username should never be null or empty! Does the Aspect work?");
            Assert.hasText((String)this.password, (String)"The password should never be null or empty! Does the Aspect work?");
            String uri = (String)this.getConfiguration().getProperties().get(CONFIG_KEY_REPOSITORY_PATH);
            Assert.hasText((String)uri, (String)"URI should never be null or empty!");
            this.log.debug("clone from Remote uri: {}", (Object)uri);
            try {
                boolean branchExist;
                this.localGit = ((CloneCommand)Git.cloneRepository().setBare(false).setCloneAllBranches(true).setBranch("master").setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(this.username, this.password))).setURI(uri).setDirectory(new File(this.baseTemporaryFileStore)).call();
                if (this.log.isDebugEnabled()) {
                    List branches = this.localGit.branchList().call();
                    for (Ref ref : branches) {
                        this.log.debug("Found branch : {}", (Object)ref.getName());
                    }
                }
                boolean bl = branchExist = this.localGit.getRepository().getRef(this.branch) != null;
                if (!branchExist) {
                    this.log.debug("Branch does not exist");
                    this.localGit.checkout().setName(this.branch).setCreateBranch(true).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).call();
                    this.log.debug("Branch created and checked out");
                } else {
                    this.log.debug("Branch does exist");
                    this.localGit.checkout().setName(this.branch).call();
                    this.log.debug("Branch checked out");
                }
                StoredConfig config = this.localGit.getRepository().getConfig();
                config.setString("branch", this.branch, "merge", "refs/heads/" + this.branch);
                config.save();
                ((PushCommand)this.localGit.push().setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(this.username, this.password))).call();
                ((PullCommand)this.localGit.pull().setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(this.username, this.password))).call();
                this.log.debug("Repository initialized with temporary file store {}", (Object)this.baseTemporaryFileStore);
            }
            catch (GitAPIException e) {
                throw new RuntimeException("Exception occurred when initialize Repository", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Exception occurred when initialize Repository", e);
            }
        }
    }

    protected boolean isRepositoryInitialized() {
        return this.localGit != null;
    }

    protected boolean isConnectorDelegateInitialized() {
        return this.delegate != null;
    }

    @Threadsafe
    @Secured
    public ConnectorNode getRoot() {
        this.pullFromRemote();
        return this.delegate.getRoot();
    }

    @Threadsafe
    @Secured
    public ContentInformation updateContent(ConnectorNode node, InputStream newContent, String message) throws Exception {
        this.pullFromRemote();
        ContentInformation temp = this.delegate.updateContent(node, newContent, message);
        this.pushToRemote(node, "Update Content for " + node.getId());
        return temp;
    }

    protected void pullFromRemote() {
        this.initRepository();
        this.log.debug("enter 'pullFromRemote'");
        try {
            ((PullCommand)this.localGit.pull().setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(this.username, this.password))).setRebase(false).call();
        }
        catch (GitAPIException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.clearCredentials();
        }
    }

    protected void pushToRemote(ConnectorNode node, String message) {
        this.initRepository();
        this.log.debug("enter 'pushToRemote', for node with Label '{}' and message '{}'", (Object)node.getId(), (Object)message);
        if (node.getType().equals((Object)ConnectorNodeType.FOLDER)) {
            this.log.debug("Is an Folder. Skip push.");
            return;
        }
        if (message == null) {
            message = "No message provided";
        }
        try {
            String path = node.getId();
            if (path.startsWith("//")) {
                path = path.substring(2);
            }
            this.log.debug("Filepattern: {}", (Object)path);
            this.localGit.add().addFilepattern(path).call();
            this.localGit.commit().setMessage(message).call();
            Iterable pushResults = ((PushCommand)this.localGit.push().setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(this.username, this.password))).setPushAll().call();
            for (PushResult pResult : pushResults) {
                for (RemoteRefUpdate u : pResult.getRemoteUpdates()) {
                    this.log.debug("RemoteRefUpdate-Status: {}", (Object)u.getStatus().toString());
                }
            }
        }
        catch (InvalidRemoteException e) {
            throw new RuntimeException(e);
        }
        catch (TransportException e) {
            throw new RuntimeException(e);
        }
        catch (GitAPIException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.clearCredentials();
        }
    }

    private void clearCredentials() {
        this.log.debug("Clear Credentials");
        this.username = "";
        this.password = "";
    }

    @Threadsafe
    @Secured
    public ConnectorNode getNode(String id) {
        this.pullFromRemote();
        return this.delegate.getNode(id);
    }

    @Threadsafe
    @Secured
    public ConnectorNode createNode(String parentId, String label, ConnectorNodeType type, String message) {
        this.pullFromRemote();
        ConnectorNode temp = this.delegate.createNode(parentId, label, type, message);
        this.pushToRemote(temp, "Create Node " + parentId + "/" + label);
        return temp;
    }

    @Threadsafe
    @Secured
    public void deleteNode(ConnectorNode node, String message) {
        this.pullFromRemote();
        this.delegate.deleteNode(node, message);
        this.pushToRemote(node, "Delete Node " + node.getId());
    }

    public ContentInformation getContentInformation(ConnectorNode node) {
        this.pullFromRemote();
        return this.delegate.getContentInformation(node);
    }

    @Threadsafe
    public void login(String userName, String password) {
        this.log.debug("Login user with username: '{}'", (Object)userName);
        this.username = userName;
        this.password = password;
    }

    public boolean needsLogin() {
        return true;
    }

    public boolean isSupportsCommitMessage() {
        return false;
    }

    public void setConfiguration(ConnectorConfiguration configuration) {
        super.setConfiguration(configuration);
    }

    public void init() {
        super.init();
    }

    public void dispose() {
        this.log.debug("enter 'dispose'");
        this.delegate.dispose();
        if (this.localGit != null) {
            this.disposeRepository();
        }
        this.localGit = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeRepository() {
        this.log.debug("enter 'disposeRepository'");
        try {
            try {
                FileUtils.deleteDirectory((File)new File(this.baseTemporaryFileStore));
            }
            catch (IOException e) {
                this.log.error("Unable to delete 'baseTemporaryFileStore'", (Throwable)e);
            }
        }
        finally {
            this.localGit = null;
        }
    }
}

