/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.connector.signavio;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.http.client.HttpResponseException;
import org.camunda.bpm.cycle.configuration.CycleConfiguration;
import org.camunda.bpm.cycle.connector.Connector;
import org.camunda.bpm.cycle.connector.ConnectorNode;
import org.camunda.bpm.cycle.connector.ConnectorNodeType;
import org.camunda.bpm.cycle.connector.ContentInformation;
import org.camunda.bpm.cycle.connector.Secured;
import org.camunda.bpm.cycle.connector.signavio.SignavioClient;
import org.camunda.bpm.cycle.connector.signavio.SignavioConnector;
import org.camunda.bpm.cycle.connector.signavio.SignavioJson;
import org.camunda.bpm.cycle.entity.ConnectorConfiguration;
import org.camunda.bpm.cycle.exception.CycleException;
import org.camunda.bpm.cycle.util.IoUtil;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class SignavioConnector
extends Connector {
    public static final String CONFIG_KEY_SIGNAVIO_BASE_URL = "signavioBaseUrl";
    public static final String CONFIG_KEY_PROXY_URL = "proxyUrl";
    public static final String CONFIG_KEY_PROXY_USERNAME = "proxyUsername";
    public static final String CONFIG_KEY_PROXY_PASSWORD = "proxyPassword";
    private static final String JSON_REL_PROP = "rel";
    private static final String JSON_DIR_VALUE = "dir";
    private static final String JSON_MOD_VALUE = "mod";
    private static final String MODEL_NAME_TEMPLATE = "cycle-import_";
    private static final String UTF_8 = "UTF-8";
    private static Logger logger = Logger.getLogger(SignavioConnector.class.getName());
    private SignavioClient signavioClient;
    private boolean loggedIn = false;
    @Inject
    private CycleConfiguration cycleConfiguration;

    public void login(String username, String password) {
        if (this.getSignavioClient() == null) {
            ConnectorConfiguration connectorConfiguration = this.getConfiguration();
            this.init(connectorConfiguration);
        }
        this.getSignavioClient().login(username, password);
        this.loggedIn = true;
    }

    public boolean needsLogin() {
        return !this.loggedIn;
    }

    public void init(ConnectorConfiguration config) {
        try {
            if (this.getSignavioClient() == null) {
                String defaultCommitMessage = this.getDefaultCommitMessage();
                this.signavioClient = new SignavioClient(this.getConfiguration().getName(), (String)this.getConfiguration().getProperties().get(CONFIG_KEY_SIGNAVIO_BASE_URL), (String)this.getConfiguration().getProperties().get(CONFIG_KEY_PROXY_URL), (String)this.getConfiguration().getProperties().get(CONFIG_KEY_PROXY_USERNAME), (String)this.getConfiguration().getProperties().get(CONFIG_KEY_PROXY_PASSWORD), defaultCommitMessage);
            }
        }
        catch (URISyntaxException e) {
            throw new CycleException("Unable to initialize Signavio REST client for connector '" + this.getConfiguration().getName() + "'!", (Throwable)e);
        }
    }

    protected String getDefaultCommitMessage() {
        if (this.cycleConfiguration != null) {
            return this.cycleConfiguration.getDefaultCommitMessage();
        }
        return "";
    }

    public void dispose() {
        if (this.getSignavioClient() != null) {
            this.getSignavioClient().dispose();
            this.signavioClient = null;
            this.loggedIn = false;
        }
    }

    public void deleteNode(ConnectorNode node, String message) {
        this.executeCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
    }

    public ConnectorNode createNode(String parentId, String label, ConnectorNodeType type, String message) {
        return (ConnectorNode)this.executeCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Secured
    public List<ConnectorNode> getChildren(ConnectorNode parent) {
        return (List)this.executeCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Secured
    public InputStream getContent(ConnectorNode node) {
        return (InputStream)this.executeCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Secured
    public ConnectorNode getRoot() {
        ConnectorNode rootNode = new ConnectorNode("/", "/");
        rootNode.setType(ConnectorNodeType.FOLDER);
        return rootNode;
    }

    @Secured
    public ContentInformation updateContent(ConnectorNode node, InputStream newContent, String message) throws Exception {
        return (ContentInformation)this.executeCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Secured
    public ContentInformation getContentInformation(ConnectorNode node) {
        return (ContentInformation)this.executeCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
    }

    private ConnectorNode createFolderNode(JSONObject jsonObj) {
        ConnectorNode node = new ConnectorNode();
        node.setType(ConnectorNodeType.FOLDER);
        node.setLabel(SignavioJson.extractNodeName((JSONObject)jsonObj));
        node.setId(SignavioJson.extractDirectoryId((JSONObject)jsonObj));
        return node;
    }

    private ConnectorNode createFileNode(JSONObject jsonObj) {
        ConnectorNode node = new ConnectorNode();
        node.setLabel(SignavioJson.extractNodeName((JSONObject)jsonObj));
        node.setId(SignavioJson.extractModelId((JSONObject)jsonObj));
        node.setType(SignavioJson.extractModelContentType((JSONObject)jsonObj));
        node.setMessage(SignavioJson.extractModelComment((JSONObject)jsonObj));
        return node;
    }

    private Date getLastModifiedDate(ConnectorNode node) {
        Date lastModifiedDate = null;
        try {
            String info = this.getSignavioClient().getInfo("model", node.getId());
            String updated = SignavioJson.extractLastModifiedDateFromInfo((String)info);
            if (updated != null) {
                SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss Z");
                lastModifiedDate = dateFormatter.parse(updated);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Could not get last modified date for " + node);
        }
        return lastModifiedDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isContentAvailable(ConnectorNode node) {
        InputStream in = null;
        boolean result = false;
        try {
            in = this.getContent(node);
            if (in != null) {
                result = true;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "No content available for " + node, e);
        }
        finally {
            IoUtil.closeSilently((InputStream)in);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream wrapStream(InputStream inputStream) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(IoUtil.readInputStream((InputStream)inputStream, (String)"PNG_or_XML_InputStream"));
            return byteArrayInputStream;
        }
        finally {
            IoUtil.closeSilently((InputStream)inputStream);
        }
    }

    private ConnectorNode getParent(ConnectorNode node) {
        try {
            String info = this.getSignavioClient().getInfo(this.extractType(node), node.getId());
            String parentId = SignavioJson.extractParentIdFromInfo((String)info);
            String parentName = SignavioJson.extractParentNameFromInfo((String)info);
            ConnectorNode result = new ConnectorNode(parentId, parentName);
            result.setType(ConnectorNodeType.FOLDER);
            return result;
        }
        catch (Exception e) {
            throw new CycleException("The parent of node '" + node.getLabel() + "' could not be determined.", (Throwable)e);
        }
    }

    @Secured
    public ConnectorNode getPrivateFolder() {
        try {
            String children = this.getSignavioClient().getChildren(this.getRoot().getId());
            return new ConnectorNode(SignavioJson.extractPrivateFolderId((String)children), SignavioJson.extractPrivateFolderName((String)children), ConnectorNodeType.FOLDER);
        }
        catch (RuntimeException e) {
            throw new CycleException("The private folder could not be determined.", (Throwable)e);
        }
    }

    protected ConnectorNode importContent(ConnectorNode parent, String content) throws Exception {
        String modelName = MODEL_NAME_TEMPLATE + new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());
        return this.importContent(parent, content, modelName);
    }

    protected ConnectorNode importContent(ConnectorNode parent, String content, String modelName) throws Exception {
        this.getSignavioClient().importBpmnXml(parent.getId(), content, modelName);
        return this.getChildNodeByName(parent, modelName);
    }

    @Secured
    public List<ConnectorNode> importSignavioArchive(ConnectorNode parentFolder, String signavioArchive) throws Exception {
        this.getSignavioClient().importSignavioArchive(parentFolder.getId(), signavioArchive);
        return this.getChildren(parentFolder);
    }

    private ConnectorNode getChildNodeByName(ConnectorNode parent, String nodeName) {
        List children = this.getChildren(parent);
        for (ConnectorNode connectorNode : children) {
            if (!connectorNode.getLabel().equals(nodeName)) continue;
            return connectorNode;
        }
        throw new CycleException("A node named '" + nodeName + "' could not be found in '" + parent.getLabel() + "'.");
    }

    private String extractType(ConnectorNode node) {
        ConnectorNodeType t = node.getType();
        if (t != null) {
            if (t.isFile()) {
                return "model";
            }
            if (t.equals((Object)ConnectorNodeType.FOLDER)) {
                return "directory";
            }
        }
        throw new CycleException("The type of the selected node '" + node.getLabel() + "' could not be determined, so that the parent could not be loaded.");
    }

    protected SignavioClient getSignavioClient() {
        return this.signavioClient;
    }

    public ConnectorNode getNode(String id) {
        throw new UnsupportedOperationException();
    }

    public boolean isSupportsCommitMessage() {
        return true;
    }

    protected <T> T executeCommand(Command<T> command) {
        try {
            Object result = command.execute();
            return (T)result;
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 401) {
                throw new CycleException("Failed to authenticate (Status 401)", (Throwable)e);
            }
            throw new CycleException("Could not execute action", (Throwable)e);
        }
        catch (Exception e) {
            throw new CycleException("Could not perform operation " + command.getOperation(), (Throwable)e);
        }
    }

    static /* synthetic */ String access$000(SignavioConnector x0, ConnectorNode x1) {
        return x0.extractType(x1);
    }

    static /* synthetic */ ConnectorNode access$100(SignavioConnector x0, JSONObject x1) {
        return x0.createFolderNode(x1);
    }

    static /* synthetic */ ConnectorNode access$200(SignavioConnector x0, JSONObject x1) {
        return x0.createFileNode(x1);
    }

    static /* synthetic */ InputStream access$300(SignavioConnector x0, InputStream x1) {
        return x0.wrapStream(x1);
    }

    static /* synthetic */ ConnectorNode access$400(SignavioConnector x0, ConnectorNode x1) {
        return x0.getParent(x1);
    }

    static /* synthetic */ boolean access$500(SignavioConnector x0, ConnectorNode x1) {
        return x0.isContentAvailable(x1);
    }

    static /* synthetic */ Date access$600(SignavioConnector x0, ConnectorNode x1) {
        return x0.getLastModifiedDate(x1);
    }
}

