/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.connector.svn;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.camunda.bpm.cycle.configuration.CycleConfiguration;
import org.camunda.bpm.cycle.connector.Connector;
import org.camunda.bpm.cycle.connector.ConnectorNode;
import org.camunda.bpm.cycle.connector.ConnectorNodeType;
import org.camunda.bpm.cycle.connector.ContentInformation;
import org.camunda.bpm.cycle.connector.Secured;
import org.camunda.bpm.cycle.connector.Threadsafe;
import org.camunda.bpm.cycle.connector.svn.SvnConnector;
import org.camunda.bpm.cycle.entity.ConnectorConfiguration;
import org.camunda.bpm.cycle.exception.CycleException;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.svnkit.SvnKitClientAdapter;
import org.tigris.subversion.svnclientadapter.svnkit.SvnKitClientAdapterFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SvnConnector
extends Connector {
    public static final String CONFIG_KEY_REPOSITORY_PATH = "repositoryPath";
    public static final String CONFIG_KEY_TEMPORARY_FILE_STORE = "temporaryFileStore";
    public static final String DEFAULT_CONFIG_KEY_TEMPORARY_FILE_STORE = "/tmp";
    private static final String SLASH_CHAR = "/";
    private static Logger logger = Logger.getLogger(SvnConnector.class.getName());
    private String baseTemporaryFileStore;
    private String baseUrl;
    private ISVNClientAdapter svnClientAdapter;
    private ReentrantLock transactionLock = new ReentrantLock();
    private boolean loggedIn;
    @Inject
    private CycleConfiguration cycleConfiguration;

    private static void setupFactories() {
        boolean initialized = false;
        try {
            SvnKitClientAdapterFactory.setup();
            initialized = true;
        }
        catch (SVNClientException e) {
            logger.log(Level.INFO, "Cannot initialize the SvnKitClientAdapterFactory.");
        }
        if (!initialized) {
            try {
                CmdLineClientAdapterFactory.setup();
            }
            catch (SVNClientException e) {
                logger.log(Level.INFO, "Cannot initialize the CmdLineClientAdapterFactory.");
            }
        }
    }

    public void init(ConnectorConfiguration config) {
        if (this.svnClientAdapter == null) {
            System.setProperty("svnkit.http.methods", "Basic,NTLM");
            this.svnClientAdapter = new SvnKitClientAdapter();
        }
        this.baseTemporaryFileStore = (String)config.getProperties().get("temporaryFileStore");
        if (this.baseTemporaryFileStore == null) {
            this.baseTemporaryFileStore = "/tmp";
        }
        if (this.baseTemporaryFileStore.matches("\\$\\{.*\\}")) {
            String systemProperty = this.baseTemporaryFileStore.substring(2, this.baseTemporaryFileStore.length() - 1);
            String systemPropertyValue = System.getProperty(this.baseTemporaryFileStore.substring(2, this.baseTemporaryFileStore.length() - 1));
            if (systemPropertyValue != null) {
                try {
                    this.baseTemporaryFileStore = new File(systemPropertyValue).toURI().toString();
                    logger.info("Loading temporary file store path from system property " + systemProperty + ": " + this.baseTemporaryFileStore);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Could not read temporary file store path from system property " + this.baseTemporaryFileStore);
                    this.baseTemporaryFileStore = "/tmp";
                }
            }
        }
        this.baseUrl = (String)this.getConfiguration().getProperties().get("repositoryPath");
    }

    public boolean needsLogin() {
        return !this.loggedIn;
    }

    @Threadsafe
    public void login(String userName, String password) {
        this.svnClientAdapter.setUsername(userName);
        this.svnClientAdapter.setPassword(password);
        this.loggedIn = true;
    }

    private SVNUrl createSvnUrl(ConnectorNode node) throws Exception {
        return this.createSvnUrl(node.getId());
    }

    private SVNUrl createSvnUrl(String id) throws Exception {
        String result;
        if (!this.baseUrl.endsWith("/") && !id.startsWith("/")) {
            id = "/" + id;
        }
        if ((result = this.baseUrl + id).endsWith("//")) {
            result = result.substring(0, result.length() - 1);
        }
        return new SVNUrl(result);
    }

    @Threadsafe
    @Secured
    public List<ConnectorNode> getChildren(ConnectorNode parent) {
        try {
            ISVNDirEntry[] entries;
            ArrayList<ConnectorNode> nodes = new ArrayList<ConnectorNode>();
            SVNUrl svnUrl = this.createSvnUrl(parent);
            for (ISVNDirEntry currentEntry : entries = this.svnClientAdapter.getList(svnUrl, SVNRevision.HEAD, false)) {
                String id = parent.getId();
                if (!id.endsWith("/")) {
                    id = id + "/";
                }
                id = id + currentEntry.getPath();
                ConnectorNode newNode = new ConnectorNode(id);
                this.decorateConnectorNode(newNode, currentEntry);
                nodes.add(newNode);
            }
            return nodes;
        }
        catch (Exception e) {
            logger.log(Level.FINER, "Cannot get children for node " + parent.getId(), e);
            throw new CycleException("Children for SVN connector '" + this.getConfiguration().getName() + "' could not be loaded from repository '" + parent.getId() + "'.", (Throwable)e);
        }
    }

    @Secured
    public ConnectorNode getRoot() {
        ConnectorNode rootNode = new ConnectorNode("/", "/");
        rootNode.setType(ConnectorNodeType.FOLDER);
        return rootNode;
    }

    @Threadsafe
    @Secured
    public ConnectorNode getNode(String id) {
        try {
            SVNUrl svnUrl = this.createSvnUrl(id);
            ISVNDirEntry entry = this.svnClientAdapter.getDirEntry(svnUrl, SVNRevision.HEAD);
            if (entry != null) {
                ConnectorNode node = new ConnectorNode(id);
                node.setMessage(this.extractCommitMessage(svnUrl, entry));
                return this.decorateConnectorNode(node, entry);
            }
        }
        catch (Exception e) {
            logger.log(Level.FINER, "Cannot get node '" + id + "' in Svn '" + this.getId() + "'.", e);
        }
        return null;
    }

    protected String extractCommitMessage(SVNUrl svnUrl, ISVNDirEntry entry) throws SVNClientException {
        ISVNProperty[] properties = this.svnClientAdapter.getRevProperties(svnUrl, entry.getLastChangedRevision());
        for (int i = 0; i < properties.length; ++i) {
            ISVNProperty prop = properties[i];
            if (!"svn:log".equals(prop.getName())) continue;
            return prop.getValue();
        }
        return null;
    }

    private ConnectorNode decorateConnectorNode(ConnectorNode node, ISVNDirEntry entry) {
        node.setLabel(entry.getPath());
        node.setLastModified(entry.getLastChangedDate());
        node.setConnectorId(this.getId());
        node.setType(this.extractFileType(entry));
        return node;
    }

    private ConnectorNodeType extractFileType(ISVNDirEntry entry) {
        if (entry.getNodeKind() != SVNNodeKind.FILE) {
            return ConnectorNodeType.FOLDER;
        }
        String name = entry.getPath();
        if (name.endsWith(".xml") || name.endsWith(".bpmn")) {
            return ConnectorNodeType.BPMN_FILE;
        }
        if (name.endsWith(".png")) {
            return ConnectorNodeType.PNG_FILE;
        }
        return ConnectorNodeType.ANY_FILE;
    }

    @Threadsafe
    @Secured
    public ConnectorNode createNode(String parentId, String label, ConnectorNodeType type, String message) {
        ConnectorNode connectorNode;
        File temporaryFileStore = null;
        try {
            if (type == null || type == ConnectorNodeType.UNSPECIFIED) {
                throw new IllegalArgumentException("Must specify a valid node type");
            }
            this.beginTransaction();
            String id = "";
            if (!parentId.endsWith("/") && !label.startsWith("/")) {
                parentId = parentId + "/";
            }
            id = parentId + label;
            String parentFolder = this.extractParentFolder(id);
            temporaryFileStore = this.getTemporaryFileStore(parentFolder + File.separator + UUID.randomUUID().toString());
            SVNUrl svnUrl = this.createSvnUrl(parentFolder);
            this.checkout(svnUrl, temporaryFileStore);
            File newFile = new File(temporaryFileStore + File.separator + label);
            if (type != ConnectorNodeType.FOLDER) {
                newFile.createNewFile();
                this.svnClientAdapter.addFile(newFile);
            } else if (type == ConnectorNodeType.FOLDER) {
                newFile.mkdir();
                this.svnClientAdapter.addDirectory(newFile, true);
            }
            String defaultMessage = this.getDefaultCommitMessage("Created node '" + label + "' in '" + parentFolder + "' using camunda cycle.");
            if (message == null || message.length() == 0) {
                message = defaultMessage;
            }
            this.commit(new File[]{temporaryFileStore}, message);
            connectorNode = new ConnectorNode(id, label, this.getId(), type, message);
        }
        catch (Exception e) {
            try {
                logger.log(Level.FINER, "Error while creating node '" + label + "'.", e);
                throw new CycleException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.stopTransaction();
                if (temporaryFileStore != null) {
                    this.deleteRecursively(temporaryFileStore);
                }
                throw throwable;
            }
        }
        this.stopTransaction();
        if (temporaryFileStore != null) {
            this.deleteRecursively(temporaryFileStore);
        }
        return connectorNode;
    }

    @Threadsafe
    @Secured
    public void deleteNode(ConnectorNode node, String message) {
        String id = node.getId();
        try {
            SVNUrl svnUrl = this.createSvnUrl(id);
            String defaultMessage = this.getDefaultCommitMessage("Removed '" + id + "' using camunda cycle.");
            if (message == null || message.length() == 0) {
                message = defaultMessage;
            }
            this.svnClientAdapter.remove(new SVNUrl[]{svnUrl}, message);
        }
        catch (Exception e) {
            logger.log(Level.FINER, "Error while deleting node '" + id + "'.", e);
            throw new CycleException((Throwable)e);
        }
    }

    protected String getDefaultCommitMessage(String string) {
        if (this.cycleConfiguration != null) {
            return this.cycleConfiguration.getDefaultCommitMessage();
        }
        return string;
    }

    @Threadsafe
    @Secured
    public ContentInformation updateContent(ConnectorNode node, InputStream newContent, String message) {
        File temporaryFileStore = null;
        try {
            this.beginTransaction();
            temporaryFileStore = this.getTemporaryFileStore(UUID.randomUUID().toString());
            String parentFolderId = this.extractParentFolder(node);
            SVNUrl svnUrl = this.createSvnUrl(parentFolderId);
            this.checkout(svnUrl, temporaryFileStore);
            File file = new File(temporaryFileStore.getAbsolutePath() + File.separator + node.getLabel());
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
            IOUtils.copy((InputStream)newContent, (OutputStream)bos);
            bos.flush();
            bos.close();
            String defaultMessage = this.getDefaultCommitMessage("Updated file '" + node.getLabel() + "' in '" + parentFolderId + "' using camunda cycle");
            if (message == null || message.length() == 0) {
                message = defaultMessage;
            }
            this.commit(new File[]{temporaryFileStore}, message);
            ContentInformation contentInformation = this.getContentInformation(node);
            return contentInformation;
        }
        catch (Exception e) {
            logger.log(Level.FINER, "Error while updating file '" + node.getLabel() + "' in '" + this.extractParentFolder(node) + "'.", e);
            throw new CycleException((Throwable)e);
        }
        finally {
            this.stopTransaction();
            if (temporaryFileStore != null) {
                this.deleteRecursively(temporaryFileStore);
            }
        }
    }

    private void beginTransaction() {
        this.transactionLock.lock();
    }

    private void stopTransaction() {
        try {
            while (true) {
                this.transactionLock.unlock();
            }
        }
        catch (Exception e) {
            return;
        }
    }

    private File getTemporaryFileStore(String withSubFolder) {
        return new File(this.baseTemporaryFileStore + File.separator + withSubFolder);
    }

    private void checkout(SVNUrl source, File target) {
        try {
            this.svnClientAdapter.checkout(source, target, SVNRevision.HEAD, false);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not checkout from svn repository '" + source + "' to the following destination '" + target.getAbsolutePath() + "'.", e);
            throw new CycleException((Throwable)e);
        }
    }

    private void commit(File[] sources, String comment) {
        try {
            this.svnClientAdapter.commit(sources, comment, true);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not commit changes in '" + sources[0] + "'.", e);
            throw new CycleException((Throwable)e);
        }
    }

    private String extractParentFolder(ConnectorNode node) {
        return this.extractParentFolder(node.getId());
    }

    private String extractParentFolder(String nodeId) {
        String parentFolderId = "";
        if (nodeId.contains("/")) {
            parentFolderId = nodeId.substring(0, nodeId.lastIndexOf("/"));
        }
        return parentFolderId;
    }

    private boolean deleteRecursively(File file) {
        if (!file.exists()) {
            return false;
        }
        if (file.isFile()) {
            return file.delete();
        }
        boolean result = true;
        File[] children = file.listFiles();
        for (int i = 0; i < children.length; ++i) {
            result &= this.deleteRecursively(children[i]);
        }
        return result &= file.delete();
    }

    @Threadsafe
    @Secured
    public InputStream getContent(ConnectorNode node) {
        try {
            return this.svnClientAdapter.getContent(this.createSvnUrl(this.getTypedNodeSpecificPath(node)), SVNRevision.HEAD);
        }
        catch (Exception e) {
            if (node.getType() == ConnectorNodeType.PNG_FILE) {
                return null;
            }
            throw new CycleException((Throwable)e);
        }
    }

    private String getTypedNodeSpecificPath(ConnectorNode node) {
        String path = node.getId();
        switch (1.$SwitchMap$org$camunda$bpm$cycle$connector$ConnectorNodeType[node.getType().ordinal()]) {
            case 1: {
                int pointIndex = path.lastIndexOf(".");
                if (pointIndex != -1) {
                    return path.substring(0, pointIndex) + ".png";
                }
                return path + ".png";
            }
        }
        return path;
    }

    @Threadsafe
    @Secured
    public ContentInformation getContentInformation(ConnectorNode node) {
        ConnectorNode reloadedNode = null;
        try {
            reloadedNode = this.getNode(this.getTypedNodeSpecificPath(node));
        }
        catch (Exception e) {
            return ContentInformation.notFound();
        }
        if (reloadedNode == null) {
            return ContentInformation.notFound();
        }
        if (reloadedNode.getType() == ConnectorNodeType.FOLDER) {
            throw new IllegalArgumentException("Can only get content information from files");
        }
        return new ContentInformation(true, reloadedNode.getLastModified());
    }

    public void dispose() {
        if (this.svnClientAdapter != null) {
            this.svnClientAdapter.dispose();
            this.svnClientAdapter = null;
        }
        this.loggedIn = false;
    }

    public boolean isSupportsCommitMessage() {
        return true;
    }

    static {
        SvnConnector.setupFactories();
    }
}

