/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.connector.vfs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileNotFolderException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.VFS;
import org.camunda.bpm.cycle.connector.Connector;
import org.camunda.bpm.cycle.connector.ConnectorNode;
import org.camunda.bpm.cycle.connector.ConnectorNodeType;
import org.camunda.bpm.cycle.connector.ContentInformation;
import org.camunda.bpm.cycle.connector.Secured;
import org.camunda.bpm.cycle.connector.util.ConnectorNodeComparator;
import org.camunda.bpm.cycle.connector.vfs.VfsConnector;
import org.camunda.bpm.cycle.entity.ConnectorConfiguration;
import org.camunda.bpm.cycle.exception.CycleException;
import org.camunda.bpm.cycle.util.IoUtil;

public class VfsConnector
extends Connector {
    public static final String BASE_PATH_KEY = "BASE_PATH";
    public static final String DEFAULT_BASE_PATH = "file://" + System.getProperty("user.home") + File.separatorChar + "cycle" + File.separatorChar;
    private static Logger logger = Logger.getLogger(VfsConnector.class.getSimpleName());
    private String basePath;

    @Secured
    public List<ConnectorNode> getChildren(ConnectorNode node) {
        ArrayList<ConnectorNode> nodes = new ArrayList<ConnectorNode>();
        try {
            FileObject[] children;
            FileObject fileObject = this.getFileObject(node);
            if (fileObject.getType() == FileType.FILE) {
                return Collections.emptyList();
            }
            for (FileObject file : children = fileObject.getChildren()) {
                if (!this.canAddFile(file)) continue;
                String baseName = file.getName().getBaseName();
                ConnectorNode child = new ConnectorNode(node.getId() + "/" + baseName, baseName, this.getId());
                child.setType(this.extractFileType(file));
                try {
                    child.setLastModified(new Date(file.getContent().getLastModifiedTime()));
                }
                catch (Exception exception) {
                    logger.fine("Could not set last modified time");
                }
                nodes.add(child);
            }
            Collections.sort(nodes, new ConnectorNodeComparator());
            return nodes;
        }
        catch (FileSystemException e) {
            throw new CycleException((Throwable)e);
        }
    }

    private boolean canAddFile(FileObject file) throws FileSystemException {
        FileType fileType = file.getType();
        if (fileType == FileType.FILE) {
            return true;
        }
        if (fileType == FileType.FOLDER) {
            try {
                file.getChildren();
                return true;
            }
            catch (FileNotFolderException e) {
                return false;
            }
        }
        return false;
    }

    @Secured
    public InputStream getContent(ConnectorNode node) {
        try {
            FileObject file = this.getFileObject(node);
            if (!file.exists()) {
                return null;
            }
            if (file.getType() != FileType.FILE) {
                return null;
            }
            InputStream is = file.getContent().getInputStream();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)is, (OutputStream)os);
            IOUtils.closeQuietly((InputStream)is);
            return new ByteArrayInputStream(os.toByteArray());
        }
        catch (IOException e) {
            throw new CycleException((Throwable)e);
        }
    }

    public void init(ConnectorConfiguration config) {
        this.basePath = (String)config.getProperties().get(BASE_PATH_KEY);
        if (this.basePath.matches("\\$\\{.*\\}")) {
            String systemProperty = this.basePath.substring(2, this.basePath.length() - 1);
            String systemPropertyValue = System.getProperty(this.basePath.substring(2, this.basePath.length() - 1));
            if (systemPropertyValue != null) {
                try {
                    this.basePath = new File(systemPropertyValue).toURI().toString();
                    logger.info("Loading base path from system property " + systemProperty + ": " + this.basePath);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Could not read base path from system property " + this.basePath);
                    this.basePath = DEFAULT_BASE_PATH;
                }
            }
        }
    }

    @Secured
    public ConnectorNode getRoot() {
        ConnectorNode rootNode = new ConnectorNode("/", "/");
        rootNode.setType(ConnectorNodeType.FOLDER);
        return rootNode;
    }

    @Secured
    public ContentInformation updateContent(ConnectorNode node, InputStream newContent, String message) throws Exception {
        try {
            FileObject fileObject = this.getFileObject(node);
            if (!fileObject.exists()) {
                throw new CycleException("File '" + node.getLabel() + "' does not exist.");
            }
            if (fileObject.getType() != FileType.FILE) {
                throw new CycleException("Unable to update content of file '" + node.getLabel() + "': Assigned file is not a file.");
            }
            FileContent content = fileObject.getContent();
            OutputStream os = content.getOutputStream();
            IOUtils.copy((InputStream)newContent, (OutputStream)os);
            os.flush();
            IoUtil.closeSilently((OutputStream)os);
            content.close();
            return this.getContentInformation(node);
        }
        catch (FileSystemException e) {
            throw new CycleException("Could not update file contents", (Throwable)e);
        }
    }

    public ConnectorNode getNode(String id) {
        try {
            FileSystemManager fsManager = VFS.getManager();
            FileObject file = fsManager.resolveFile(this.createPath(id));
            if (!file.exists()) {
                return null;
            }
            String baseName = file.getName().getBaseName();
            ConnectorNode node = new ConnectorNode(id, baseName);
            node.setType(this.extractFileType(file));
            return node;
        }
        catch (Exception e) {
            throw new CycleException((Throwable)e);
        }
    }

    public ConnectorNode createNode(String parentId, String label, ConnectorNodeType type, String message) {
        if (type == null || type == ConnectorNodeType.UNSPECIFIED) {
            throw new IllegalArgumentException("Must specify a valid node type");
        }
        try {
            String id = "";
            if (!parentId.endsWith("/") && !label.startsWith("/")) {
                parentId = parentId + "/";
            }
            id = parentId + label;
            FileSystemManager fsManager = VFS.getManager();
            FileObject file = fsManager.resolveFile(this.createPath(id));
            if (type.isFile()) {
                file.createFile();
            } else {
                file.createFolder();
            }
            return new ConnectorNode(id, label, type);
        }
        catch (Exception e) {
            throw new CycleException((Throwable)e);
        }
    }

    public void deleteNode(ConnectorNode node, String message) {
        try {
            FileSystemManager fsManager = VFS.getManager();
            FileObject fileObject = fsManager.resolveFile(this.createPath(node.getId()));
            fileObject.delete();
        }
        catch (Exception e) {
            throw new CycleException((Throwable)e);
        }
    }

    private String createPath(String pathSuffix) {
        if (!this.basePath.endsWith("/") && !pathSuffix.startsWith("/")) {
            pathSuffix = "/" + pathSuffix;
        }
        return this.basePath + pathSuffix;
    }

    @Secured
    public ContentInformation getContentInformation(ConnectorNode node) {
        try {
            return this.getContentInformation(this.getFileObject(node));
        }
        catch (FileSystemException e) {
            throw new RuntimeException("Content information unavailable", e);
        }
    }

    private ContentInformation getContentInformation(FileObject file) throws FileSystemException {
        if (!file.exists()) {
            return ContentInformation.notFound();
        }
        if (file.getType() != FileType.FILE) {
            throw new IllegalArgumentException("Can only get content information from files");
        }
        return new ContentInformation(true, this.getLastModifiedDate(file));
    }

    private Date getLastModifiedDate(FileObject file) throws FileSystemException {
        if (file.getType() != FileType.FILE) {
            return null;
        }
        return new Date(file.getContent().getLastModifiedTime());
    }

    private FileObject getFileObject(ConnectorNode node) throws FileSystemException {
        String path = this.getTypedNodeSpecificPath(node);
        FileSystemManager fsManager = VFS.getManager();
        return fsManager.resolveFile(this.createPath(path));
    }

    private ConnectorNodeType extractFileType(FileObject file) throws FileSystemException {
        if (file.getType() != FileType.FILE) {
            return ConnectorNodeType.FOLDER;
        }
        String name = file.getName().getBaseName();
        if (name.endsWith(".xml") || name.endsWith(".bpmn")) {
            return ConnectorNodeType.BPMN_FILE;
        }
        if (name.endsWith(".png")) {
            return ConnectorNodeType.PNG_FILE;
        }
        return ConnectorNodeType.ANY_FILE;
    }

    private String getTypedNodeSpecificPath(ConnectorNode node) {
        String path = node.getId();
        switch (1.$SwitchMap$org$camunda$bpm$cycle$connector$ConnectorNodeType[node.getType().ordinal()]) {
            case 1: {
                int pointIndex = path.lastIndexOf(".");
                if (pointIndex != -1) {
                    return path.substring(0, pointIndex) + ".png";
                }
                return path + ".png";
            }
        }
        return path;
    }

    public boolean needsLogin() {
        return false;
    }

    public boolean isSupportsCommitMessage() {
        return false;
    }
}

