/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.util;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.camunda.bpm.cycle.exception.CycleException;
import org.camunda.bpm.cycle.util.BpmnNamespaceContext;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * Exception performing whole class analysis ignored.
 */
public class XmlUtil {
    public static final String SAXON_SF_NET_JAXP_XPATH_OM = "http://saxon.sf.net/jaxp/xpath/om";
    public static final String SAXON_XPATH_FACTORY = "net.sf.saxon.xpath.XPathFactoryImpl";

    public static String getXPathResult(String expression, InputSource source) {
        return XmlUtil.getXPathResult((String)expression, (Object)source);
    }

    public static String getXPathResult(String expression, Node contextItem) {
        if (contextItem == null) {
            throw new NullPointerException();
        }
        return XmlUtil.getXPathResult((String)expression, (Object)contextItem);
    }

    public static String getXPathResult(String expression, String sourceXml) {
        try {
            return XmlUtil.getXPathResult((String)expression, (InputSource)new InputSource(new ByteArrayInputStream(sourceXml.getBytes("UTF-8"))));
        }
        catch (UnsupportedEncodingException e) {
            throw new CycleException((Throwable)e);
        }
    }

    private static String getXPathResult(String expression, Object item) {
        try {
            XPathExpression xPathExpression = XmlUtil.initXPathFactoryAndCompileExpression((String)expression);
            if (item instanceof InputSource) {
                return xPathExpression.evaluate((InputSource)item);
            }
            return xPathExpression.evaluate(item);
        }
        catch (XPathExpressionException e) {
            throw new CycleException((Throwable)e);
        }
    }

    public static boolean containsElementByValue(NodeList elements, String value) {
        for (int i = 0; i < elements.getLength(); ++i) {
            Node node = elements.item(i);
            if (!node.getTextContent().equals(value)) continue;
            return true;
        }
        return false;
    }

    public static Node getSingleElementByXPath(Object searchContext, String expression) {
        NodeList elementsWithThatId;
        XPathExpression xPathExpression = XmlUtil.initXPathFactoryAndCompileExpression((String)expression);
        try {
            elementsWithThatId = (NodeList)xPathExpression.evaluate(searchContext, XPathConstants.NODESET);
            if (elementsWithThatId == null) {
                return null;
            }
        }
        catch (XPathExpressionException e) {
            throw new CycleException("Error during evaluation of XPath expression '" + expression + "'.", (Throwable)e);
        }
        if (elementsWithThatId.getLength() == 0) {
            return null;
        }
        if (elementsWithThatId.getLength() == 1) {
            return elementsWithThatId.item(0);
        }
        throw new CycleException("There are multiple elements matching'" + expression + "'.");
    }

    public static NodeList getListOfElementsByXPath(Object searchContext, String expression) {
        XPathExpression xPathExpression = XmlUtil.initXPathFactoryAndCompileExpression((String)expression);
        try {
            return (NodeList)xPathExpression.evaluate(searchContext, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new CycleException("Error during evaluation of XPath expression '" + expression + "'.", (Throwable)e);
        }
    }

    private static XPathExpression initXPathFactoryAndCompileExpression(String expression) {
        try {
            XPathFactory xPathFactory = XPathFactory.newInstance("http://saxon.sf.net/jaxp/xpath/om", "net.sf.saxon.xpath.XPathFactoryImpl", null);
            XPath xPath = xPathFactory.newXPath();
            xPath.setNamespaceContext((NamespaceContext)new BpmnNamespaceContext());
            XPathExpression xPathExpression = xPath.compile(expression);
            return xPathExpression;
        }
        catch (XPathExpressionException e) {
            throw new CycleException("Error during evaluation of XPath expression '" + expression + "'.", (Throwable)e);
        }
        catch (XPathFactoryConfigurationException e) {
            throw new CycleException((Throwable)e);
        }
    }
}

