/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.web.dto;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.camunda.bpm.cycle.connector.ConnectorStatus;

public class ConnectorStatusDTO {
    private ConnectorStatus.State status;
    private String exceptionMessage;
    private String message;

    public ConnectorStatusDTO(ConnectorStatus.State status, Exception exception) {
        this.status = status;
        if (exception != null) {
            this.message = exception.getMessage();
            this.exceptionMessage = this.buildExceptionMessage(exception);
        }
    }

    private ConnectorStatusDTO(ConnectorStatus status) {
        this(status.getState(), status.getException());
    }

    private String buildExceptionMessage(Exception exception) {
        StringWriter writer = new StringWriter();
        exception.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    public ConnectorStatus.State getState() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public static ConnectorStatusDTO wrap(ConnectorStatus status) {
        return new ConnectorStatusDTO(status);
    }
}

