/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.web.service;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.camunda.bpm.cycle.configuration.CycleConfiguration;
import org.camunda.bpm.cycle.entity.User;
import org.camunda.bpm.cycle.repository.UserRepository;
import org.camunda.bpm.cycle.security.IdentityHolder;
import org.camunda.bpm.cycle.web.dto.UserDTO;
import org.camunda.bpm.cycle.web.service.AbstractRestService;
import org.camunda.bpm.cycle.web.service.resource.UserService;
import org.camunda.bpm.security.UserIdentity;

@Path(value="first-time-setup")
public class InitialConfigurationService
extends AbstractRestService {
    private static UserIdentity TEMP_AUTHORIZED_IDENTITY = new UserIdentity(new User("temp-user", true));
    @Inject
    private CycleConfiguration configuration;
    @Inject
    private UserService userService;
    @Inject
    private UserRepository userRepository;

    @GET
    @Produces(value={"text/html"})
    public Object createInitialUser() {
        if (this.isConfigured()) {
            return this.redirectTo("secured/view/index");
        }
        return "tpl:app/first-time-setup";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    public String createInitialUser(UserDTO data) {
        if (this.isConfigured()) {
            throw this.notAllowed("already configured");
        }
        if (data.getEmail() == null || data.getPassword() == null || data.getName() == null) {
            throw this.badRequest("invalid fields");
        }
        data.setAdmin(true);
        UserDTO user = null;
        try {
            IdentityHolder.setIdentity((UserIdentity)TEMP_AUTHORIZED_IDENTITY);
            user = this.userService.create(data);
        }
        finally {
            IdentityHolder.setIdentity(null);
        }
        return "Ok [id=" + user.getId() + "]";
    }

    private boolean isConfigured() {
        return this.configuration.isUseJaas() || this.userRepository.countAll() > 0L;
    }
}

