/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.web.service.resource;

import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.camunda.bpm.cycle.connector.ConnectorRegistry;
import org.camunda.bpm.cycle.connector.ConnectorStatus;
import org.camunda.bpm.cycle.connector.crypt.EncryptionService;
import org.camunda.bpm.cycle.entity.AbstractEntity;
import org.camunda.bpm.cycle.entity.ConnectorConfiguration;
import org.camunda.bpm.cycle.repository.ConnectorConfigurationRepository;
import org.camunda.bpm.cycle.web.dto.ConnectorConfigurationDTO;
import org.camunda.bpm.cycle.web.dto.ConnectorStatusDTO;
import org.camunda.bpm.cycle.web.service.AbstractRestService;
import org.springframework.transaction.annotation.Transactional;

@Path(value="secured/resource/connector/configuration")
public class ConnectorConfigurationService
extends AbstractRestService {
    @Inject
    protected ConnectorRegistry connectorRegistry;
    @Inject
    protected EncryptionService encryptionService;
    @Inject
    protected ConnectorConfigurationRepository connectorConfigurationRepository;

    @GET
    @Path(value="defaults")
    public List<ConnectorConfigurationDTO> listDefaults() {
        return ConnectorConfigurationDTO.wrapAll((List)this.connectorRegistry.getConnectorDefinitions());
    }

    @GET
    public List<ConnectorConfigurationDTO> list() {
        return ConnectorConfigurationDTO.wrapAll((List)this.connectorConfigurationRepository.findAll());
    }

    @GET
    @Path(value="{id}")
    public ConnectorConfigurationDTO get(@PathParam(value="id") long id) {
        return ConnectorConfigurationDTO.wrap((ConnectorConfiguration)this.findConfigurationById(id));
    }

    @POST
    @Path(value="{id}")
    @Transactional
    public ConnectorConfigurationDTO update(ConnectorConfigurationDTO data) {
        long id = data.getConnectorId();
        ConnectorConfiguration connectorConfiguration = this.findConfigurationById(id);
        this.update(connectorConfiguration, data);
        this.connectorConfigurationRepository.saveAndFlush((AbstractEntity)connectorConfiguration);
        this.connectorRegistry.getCache().remove(id);
        return ConnectorConfigurationDTO.wrap((ConnectorConfiguration)connectorConfiguration);
    }

    @POST
    public ConnectorConfigurationDTO create(ConnectorConfigurationDTO data) {
        ConnectorConfiguration connectorConfiguration = this.createConfiguration(data);
        connectorConfiguration = (ConnectorConfiguration)this.connectorConfigurationRepository.saveAndFlush((AbstractEntity)connectorConfiguration);
        return ConnectorConfigurationDTO.wrap((ConnectorConfiguration)connectorConfiguration);
    }

    @DELETE
    @Path(value="{id}")
    @Transactional
    public void delete(@PathParam(value="id") long id) {
        ConnectorConfiguration connectorConfiguration = this.findConfigurationById(id);
        this.connectorConfigurationRepository.delete((AbstractEntity)connectorConfiguration);
        this.connectorRegistry.getCache().remove(id);
    }

    @POST
    @Path(value="test")
    public ConnectorStatusDTO test(ConnectorConfigurationDTO data) {
        ConnectorConfiguration connectorConfiguration = this.createConfiguration(data);
        ConnectorStatus connectorStatus = this.connectorRegistry.testConnectorConfiguration(connectorConfiguration);
        return ConnectorStatusDTO.wrap((ConnectorStatus)connectorStatus);
    }

    private void update(ConnectorConfiguration config, ConnectorConfigurationDTO data) {
        if (data.getPassword() != null && !data.getPassword().isEmpty()) {
            config.setGlobalPassword(this.encryptionService.encryptConnectorPassword(data.getPassword()));
        }
        config.setGlobalUser(data.getUser());
        config.setLoginMode(data.getLoginMode());
        config.setProperties(data.getProperties());
        config.setName(data.getName());
        config.setUseImage(data.isUseImage());
    }

    private ConnectorConfiguration createConfiguration(ConnectorConfigurationDTO data) {
        ConnectorConfiguration config = null;
        config = data.getConnectorId() != null ? (ConnectorConfiguration)this.connectorConfigurationRepository.findById(data.getConnectorId().longValue()) : new ConnectorConfiguration();
        config.setConnectorClass(data.getConnectorClass());
        config.setConnectorName(data.getConnectorName());
        this.update(config, data);
        return config;
    }

    protected ConnectorConfiguration findConfigurationById(long id) {
        ConnectorConfiguration configuration = (ConnectorConfiguration)this.connectorConfigurationRepository.findById(id);
        if (configuration == null) {
            throw this.notFound("connector configuration not found");
        }
        return configuration;
    }
}

