/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.web.service.resource;

import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import org.camunda.bpm.cycle.connector.ConnectorRegistry;
import org.camunda.bpm.cycle.connector.ConnectorStatus;
import org.camunda.bpm.cycle.connector.crypt.EncryptionService;
import org.camunda.bpm.cycle.entity.AbstractEntity;
import org.camunda.bpm.cycle.entity.ConnectorConfiguration;
import org.camunda.bpm.cycle.entity.ConnectorCredentials;
import org.camunda.bpm.cycle.entity.User;
import org.camunda.bpm.cycle.repository.ConnectorConfigurationRepository;
import org.camunda.bpm.cycle.repository.ConnectorCredentialsRepository;
import org.camunda.bpm.cycle.repository.UserRepository;
import org.camunda.bpm.cycle.web.dto.ConnectorCredentialsDTO;
import org.camunda.bpm.cycle.web.dto.ConnectorStatusDTO;
import org.camunda.bpm.cycle.web.service.AbstractRestService;
import org.springframework.transaction.annotation.Transactional;

@Path(value="secured/resource/connector/credentials")
public class ConnectorCredentialsService
extends AbstractRestService {
    @Inject
    EncryptionService encryptionService;
    @Inject
    private ConnectorCredentialsRepository connectorCredentialsRepository;
    @Inject
    private UserRepository userRepository;
    @Inject
    private ConnectorConfigurationRepository connectorConfigurationRepository;
    @Inject
    private ConnectorRegistry connectorRegistry;

    @GET
    public List<ConnectorCredentialsDTO> list(@QueryParam(value="userId") Long userId) {
        return this.getConnectorCredentialsByUserId(userId);
    }

    @GET
    @Path(value="{id}")
    public ConnectorCredentialsDTO get(@PathParam(value="id") long id) {
        return ConnectorCredentialsDTO.wrap((ConnectorCredentials)this.getAndFetchConnectorCredentialsById(Long.valueOf(id)));
    }

    @POST
    @Path(value="{id}")
    @Transactional
    public ConnectorCredentialsDTO update(ConnectorCredentialsDTO data) {
        long id = data.getId();
        ConnectorCredentials connectorCredentials = this.getById(id);
        this.update(connectorCredentials, data);
        return ConnectorCredentialsDTO.wrap((ConnectorCredentials)connectorCredentials);
    }

    @POST
    public ConnectorCredentialsDTO create(ConnectorCredentialsDTO data) {
        this.validate(data);
        ConnectorCredentials connectorCredentials = new ConnectorCredentials();
        this.update(connectorCredentials, data);
        ConnectorConfiguration config = this.getConnectorConfigurationById(data.getConnectorId());
        connectorCredentials.setConnectorConfiguration(config);
        User user = (User)this.userRepository.findById(data.getUserId());
        if (user == null) {
            throw this.notFound("user with id " + data.getConnectorId() + " not found");
        }
        if (user.getPassword() != null) {
            user.setPassword(this.encryptionService.encryptConnectorPassword(user.getPassword()));
        }
        connectorCredentials.setUser(user);
        return ConnectorCredentialsDTO.wrap((ConnectorCredentials)((ConnectorCredentials)this.connectorCredentialsRepository.saveAndFlush((AbstractEntity)connectorCredentials)));
    }

    @DELETE
    @Path(value="{id}")
    @Transactional
    public void delete(@PathParam(value="id") long id) {
        this.connectorCredentialsRepository.delete(Long.valueOf(id));
    }

    @POST
    @Path(value="test")
    public ConnectorStatusDTO test(ConnectorCredentialsDTO data) {
        ConnectorConfiguration config = this.getConnectorConfigurationById(data.getConnectorId());
        ConnectorStatus connectorStatus = this.connectorRegistry.testConnectorConfiguration(config, data.getUsername(), data.getPassword());
        return ConnectorStatusDTO.wrap((ConnectorStatus)connectorStatus);
    }

    protected List<ConnectorCredentialsDTO> getConnectorCredentialsByUserId(@QueryParam(value="userId") Long userId) {
        return ConnectorCredentialsDTO.wrapAll((List)this.connectorCredentialsRepository.findFetchConfigurationByUserId(userId));
    }

    protected ConnectorCredentials getAndFetchConnectorCredentialsById(@QueryParam(value="id") Long id) {
        ConnectorCredentials credentials = this.connectorCredentialsRepository.findFetchConfigurationById(id);
        if (credentials == null) {
            throw this.notFound("credentials not found");
        }
        return credentials;
    }

    protected ConnectorConfiguration getConnectorConfigurationById(long configurationId) {
        ConnectorConfiguration config = (ConnectorConfiguration)this.connectorConfigurationRepository.findById(configurationId);
        if (config == null) {
            throw this.notFound("configuration with id " + configurationId + " not found");
        }
        return config;
    }

    protected ConnectorCredentials getById(long id) throws WebApplicationException {
        ConnectorCredentials connectorCredentials = (ConnectorCredentials)this.connectorCredentialsRepository.findById(id);
        if (connectorCredentials == null) {
            throw this.notFound("credentials not found");
        }
        return connectorCredentials;
    }

    private void update(ConnectorCredentials connectorCredentials, ConnectorCredentialsDTO data) {
        connectorCredentials.setUsername(data.getUsername());
        connectorCredentials.setPassword(this.encryptionService.encryptConnectorPassword(data.getPassword()));
    }

    private void validate(ConnectorCredentialsDTO data) {
        if (data.getConnectorId() == -1L) {
            throw this.badRequest("no connector id given");
        }
        if (data.getUserId() == -1L) {
            throw this.badRequest("no user id given");
        }
    }
}

