/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.aspect;

import javax.inject.Inject;
import javax.persistence.NoResultException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.camunda.bpm.cycle.connector.Connector;
import org.camunda.bpm.cycle.connector.ConnectorLoginMode;
import org.camunda.bpm.cycle.connector.crypt.EncryptionService;
import org.camunda.bpm.cycle.entity.ConnectorConfiguration;
import org.camunda.bpm.cycle.entity.ConnectorCredentials;
import org.camunda.bpm.cycle.exception.CycleException;
import org.camunda.bpm.cycle.exception.CycleMissingCredentialsException;
import org.camunda.bpm.cycle.repository.ConnectorCredentialsRepository;
import org.camunda.bpm.cycle.security.IdentityHolder;
import org.camunda.bpm.security.UserIdentity;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class LoginAspect {
    @Inject
    protected EncryptionService encryptionService;
    @Inject
    private ConnectorCredentialsRepository connectorCredentialsRepository;

    @Before(value="@annotation(org.camunda.bpm.cycle.connector.Secured)")
    private void aroundSecured(JoinPoint jp) throws Throwable {
        if (!(jp.getTarget() instanceof Connector)) {
            throw new CycleException("@Secured must only be used on Connector methods");
        }
        Connector connector = (Connector)jp.getTarget();
        this.doLogin(connector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLogin(Connector connector) {
        Connector connector2 = connector;
        synchronized (connector2) {
            if (connector.needsLogin()) {
                ConnectorConfiguration config = connector.getConfiguration();
                connector.init(config);
                this.loginConnector(connector, config, config.getLoginMode());
            }
        }
    }

    public void setConnectorCredentialsRepository(ConnectorCredentialsRepository connectorCredentialsRepository) {
        this.connectorCredentialsRepository = connectorCredentialsRepository;
    }

    private void loginConnector(Connector connector, ConnectorConfiguration config, ConnectorLoginMode loginMode) {
        if (loginMode == null) {
            return;
        }
        switch (loginMode) {
            case LOGIN_NOT_REQUIRED: {
                break;
            }
            case GLOBAL: {
                this.loginConnector(connector, config.getGlobalUser(), config.getGlobalPassword());
                break;
            }
            case USER: {
                this.loginWithUserCredentials(connector);
            }
        }
    }

    private void loginConnector(Connector connector, String username, String password) {
        connector.login(username, this.encryptionService.decryptConnectorPassword(password));
    }

    private void loginWithUserCredentials(Connector connector) {
        UserIdentity identity = IdentityHolder.getIdentity();
        if (identity == null) {
            throw this.missingCredentials("No user identity found. Please relogin into cycle.");
        }
        String username = identity.getName();
        Long connectorConfigId = connector.getConfiguration().getId();
        if (connectorConfigId == null) {
            throw this.missingCredentials("No user specific credentials configured for connector '" + connector.getConfiguration().getName() + "'.");
        }
        try {
            ConnectorCredentials credentials = this.connectorCredentialsRepository.findFetchAllByUsernameAndConnectorId(username, connectorConfigId);
            this.loginConnector(connector, credentials.getUsername(), credentials.getPassword());
        }
        catch (NoResultException e) {
            throw this.missingCredentials("No user specific credentials configured for connector '" + connector.getConfiguration().getName() + "'.");
        }
    }

    private CycleMissingCredentialsException missingCredentials(String message) {
        return new CycleMissingCredentialsException("Missing credentials: " + message);
    }
}

