/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.connector;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PreDestroy;
import org.camunda.bpm.cycle.connector.Connector;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;

@Component
@Scope(value="session", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class ConnectorCache
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Map<Long, Connector> cache = new HashMap<Long, Connector>();

    public boolean contains(long id) {
        this.ensureInitialized();
        return this.cache.containsKey(id);
    }

    public Connector remove(long id) {
        this.ensureInitialized();
        Connector oldConnector = this.cache.remove(id);
        if (oldConnector != null) {
            oldConnector.dispose();
        }
        return oldConnector;
    }

    public Connector get(long id) {
        this.ensureInitialized();
        return this.cache.get(id);
    }

    public Connector put(long id, Connector connector) {
        this.ensureInitialized();
        Connector oldConnector = this.cache.put(id, connector);
        if (oldConnector != null) {
            oldConnector.dispose();
        }
        return oldConnector;
    }

    public Collection<Connector> values() {
        this.ensureInitialized();
        return this.cache.values();
    }

    @PreDestroy
    public void dispose() {
        this.ensureInitialized();
        for (Connector c : this.cache.values()) {
            c.dispose();
        }
        this.cache = new HashMap<Long, Connector>();
    }

    private void ensureInitialized() {
        if (this.cache == null) {
            this.cache = new HashMap<Long, Connector>();
        }
    }
}

