/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.connector.signavio;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.http.client.HttpResponseException;
import org.camunda.bpm.cycle.configuration.CycleConfiguration;
import org.camunda.bpm.cycle.connector.Connector;
import org.camunda.bpm.cycle.connector.ConnectorNode;
import org.camunda.bpm.cycle.connector.ConnectorNodeType;
import org.camunda.bpm.cycle.connector.ContentInformation;
import org.camunda.bpm.cycle.connector.Secured;
import org.camunda.bpm.cycle.connector.signavio.SignavioClient;
import org.camunda.bpm.cycle.connector.signavio.SignavioJson;
import org.camunda.bpm.cycle.entity.ConnectorConfiguration;
import org.camunda.bpm.cycle.exception.CycleException;
import org.camunda.bpm.cycle.util.IoUtil;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class SignavioConnector
extends Connector {
    public static final String CONFIG_KEY_SIGNAVIO_BASE_URL = "signavioBaseUrl";
    public static final String CONFIG_KEY_PROXY_URL = "proxyUrl";
    public static final String CONFIG_KEY_PROXY_USERNAME = "proxyUsername";
    public static final String CONFIG_KEY_PROXY_PASSWORD = "proxyPassword";
    private static final String JSON_REL_PROP = "rel";
    private static final String JSON_DIR_VALUE = "dir";
    private static final String JSON_MOD_VALUE = "mod";
    private static final String MODEL_NAME_TEMPLATE = "cycle-import_";
    private static final String UTF_8 = "UTF-8";
    private static Logger logger = Logger.getLogger(SignavioConnector.class.getName());
    private SignavioClient signavioClient;
    private boolean loggedIn = false;
    @Inject
    private CycleConfiguration cycleConfiguration;

    @Override
    public void login(String username, String password) {
        if (this.getSignavioClient() == null) {
            ConnectorConfiguration connectorConfiguration = this.getConfiguration();
            this.init(connectorConfiguration);
        }
        this.getSignavioClient().login(username, password);
        this.loggedIn = true;
    }

    @Override
    public boolean needsLogin() {
        return !this.loggedIn;
    }

    @Override
    public void init(ConnectorConfiguration config) {
        try {
            if (this.getSignavioClient() == null) {
                String defaultCommitMessage = this.getDefaultCommitMessage();
                this.signavioClient = new SignavioClient(this.getConfiguration().getName(), this.getConfiguration().getProperties().get(CONFIG_KEY_SIGNAVIO_BASE_URL), this.getConfiguration().getProperties().get(CONFIG_KEY_PROXY_URL), this.getConfiguration().getProperties().get(CONFIG_KEY_PROXY_USERNAME), this.getConfiguration().getProperties().get(CONFIG_KEY_PROXY_PASSWORD), defaultCommitMessage);
            }
        }
        catch (URISyntaxException e) {
            throw new CycleException("Unable to initialize Signavio REST client for connector '" + this.getConfiguration().getName() + "'!", e);
        }
    }

    protected String getDefaultCommitMessage() {
        if (this.cycleConfiguration != null) {
            return this.cycleConfiguration.getDefaultCommitMessage();
        }
        return "";
    }

    @Override
    public void dispose() {
        if (this.getSignavioClient() != null) {
            this.getSignavioClient().dispose();
            this.signavioClient = null;
            this.loggedIn = false;
        }
    }

    @Override
    public void deleteNode(final ConnectorNode node, String message) {
        this.executeCommand(new Command<Void>("delete node"){

            @Override
            public Void execute() throws Exception {
                SignavioConnector.this.getSignavioClient().delete(SignavioConnector.this.extractType(node), node.getId());
                return null;
            }
        });
    }

    @Override
    public ConnectorNode createNode(final String parentId, final String label, final ConnectorNodeType type, final String message) {
        return this.executeCommand(new Command<ConnectorNode>("create node"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ConnectorNode execute() throws Exception {
                InputStream emptyJson = null;
                try {
                    String response = "";
                    ConnectorNode result = null;
                    switch (type) {
                        case FOLDER: {
                            response = SignavioConnector.this.getSignavioClient().createFolder(label, parentId);
                            result = SignavioConnector.this.createFolderNode(new JSONObject(response));
                            break;
                        }
                        case BPMN_FILE: {
                            response = SignavioConnector.this.getSignavioClient().createModel(parentId, label, message);
                            result = SignavioConnector.this.createFileNode(new JSONObject(response));
                        }
                    }
                    if (result != null) {
                        result.setConnectorId(SignavioConnector.this.getId());
                    }
                    ConnectorNode connectorNode = result;
                    return connectorNode;
                }
                finally {
                    IoUtil.closeSilently(emptyJson);
                }
            }
        });
    }

    @Override
    @Secured
    public List<ConnectorNode> getChildren(final ConnectorNode parent) {
        return this.executeCommand(new Command<List<ConnectorNode>>("get children"){

            @Override
            public List<ConnectorNode> execute() throws Exception {
                ArrayList<ConnectorNode> nodes = new ArrayList<ConnectorNode>();
                String result = SignavioConnector.this.getSignavioClient().getChildren(parent.getId());
                JSONArray jsonArray = new JSONArray(result);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject jsonObj = jsonArray.getJSONObject(i);
                    ConnectorNode newNode = null;
                    String relProp = jsonObj.getString(SignavioConnector.JSON_REL_PROP);
                    if (relProp.equals(SignavioConnector.JSON_DIR_VALUE)) {
                        newNode = SignavioConnector.this.createFolderNode(jsonObj);
                    } else if (relProp.equals(SignavioConnector.JSON_MOD_VALUE)) {
                        newNode = SignavioConnector.this.createFileNode(jsonObj);
                    }
                    if (newNode == null) continue;
                    newNode.setConnectorId(SignavioConnector.this.getId());
                    nodes.add(newNode);
                }
                return nodes;
            }
        });
    }

    @Override
    @Secured
    public InputStream getContent(final ConnectorNode node) {
        return this.executeCommand(new Command<InputStream>("get content information"){

            @Override
            public InputStream execute() throws Exception {
                ConnectorNodeType type = node.getType();
                switch (type) {
                    case PNG_FILE: {
                        return SignavioConnector.this.wrapStream(SignavioConnector.this.getSignavioClient().getPngContent(node.getId()));
                    }
                }
                return SignavioConnector.this.wrapStream(SignavioConnector.this.getSignavioClient().getXmlContent(node.getId()));
            }
        });
    }

    @Override
    @Secured
    public ConnectorNode getRoot() {
        ConnectorNode rootNode = new ConnectorNode("/", "/");
        rootNode.setType(ConnectorNodeType.FOLDER);
        return rootNode;
    }

    @Override
    @Secured
    public ContentInformation updateContent(final ConnectorNode node, final InputStream newContent, final String message) throws Exception {
        return this.executeCommand(new Command<ContentInformation>("get content information"){

            @Override
            public ContentInformation execute() throws Exception {
                ConnectorNode privateFolder = SignavioConnector.this.getPrivateFolder();
                ConnectorNode importedModel = SignavioConnector.this.importContent(privateFolder, IoUtil.toString(newContent, SignavioConnector.UTF_8));
                String json = SignavioConnector.this.getSignavioClient().getModelAsJson(importedModel.getId());
                String svg = SignavioConnector.this.getSignavioClient().getModelAsSVG(importedModel.getId());
                SignavioConnector.this.deleteNode(importedModel, null);
                ConnectorNode parent = SignavioConnector.this.getParent(node);
                SignavioConnector.this.getSignavioClient().updateModel(node.getId(), node.getLabel(), json, svg, parent.getId(), message);
                return SignavioConnector.this.getContentInformation(node);
            }
        });
    }

    @Override
    @Secured
    public ContentInformation getContentInformation(final ConnectorNode node) {
        return this.executeCommand(new Command<ContentInformation>("get content information"){

            @Override
            public ContentInformation execute() throws Exception {
                return new ContentInformation(SignavioConnector.this.isContentAvailable(node), SignavioConnector.this.getLastModifiedDate(node));
            }
        });
    }

    private ConnectorNode createFolderNode(JSONObject jsonObj) {
        ConnectorNode node = new ConnectorNode();
        node.setType(ConnectorNodeType.FOLDER);
        node.setLabel(SignavioJson.extractNodeName(jsonObj));
        node.setId(SignavioJson.extractDirectoryId(jsonObj));
        return node;
    }

    private ConnectorNode createFileNode(JSONObject jsonObj) {
        ConnectorNode node = new ConnectorNode();
        node.setLabel(SignavioJson.extractNodeName(jsonObj));
        node.setId(SignavioJson.extractModelId(jsonObj));
        node.setType(SignavioJson.extractModelContentType(jsonObj));
        node.setMessage(SignavioJson.extractModelComment(jsonObj));
        return node;
    }

    private Date getLastModifiedDate(ConnectorNode node) {
        Date lastModifiedDate = null;
        try {
            String info = this.getSignavioClient().getInfo("model", node.getId());
            String updated = SignavioJson.extractLastModifiedDateFromInfo(info);
            if (updated != null) {
                SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss Z");
                lastModifiedDate = dateFormatter.parse(updated);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Could not get last modified date for " + node);
        }
        return lastModifiedDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isContentAvailable(ConnectorNode node) {
        InputStream in = null;
        boolean result = false;
        try {
            in = this.getContent(node);
            if (in != null) {
                result = true;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "No content available for " + node, e);
        }
        finally {
            IoUtil.closeSilently(in);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream wrapStream(InputStream inputStream) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(IoUtil.readInputStream(inputStream, "PNG_or_XML_InputStream"));
            return byteArrayInputStream;
        }
        finally {
            IoUtil.closeSilently(inputStream);
        }
    }

    private ConnectorNode getParent(ConnectorNode node) {
        try {
            String info = this.getSignavioClient().getInfo(this.extractType(node), node.getId());
            String parentId = SignavioJson.extractParentIdFromInfo(info);
            String parentName = SignavioJson.extractParentNameFromInfo(info);
            ConnectorNode result = new ConnectorNode(parentId, parentName);
            result.setType(ConnectorNodeType.FOLDER);
            return result;
        }
        catch (Exception e) {
            throw new CycleException("The parent of node '" + node.getLabel() + "' could not be determined.", e);
        }
    }

    @Secured
    public ConnectorNode getPrivateFolder() {
        try {
            String children = this.getSignavioClient().getChildren(this.getRoot().getId());
            return new ConnectorNode(SignavioJson.extractPrivateFolderId(children), SignavioJson.extractPrivateFolderName(children), ConnectorNodeType.FOLDER);
        }
        catch (RuntimeException e) {
            throw new CycleException("The private folder could not be determined.", e);
        }
    }

    protected ConnectorNode importContent(ConnectorNode parent, String content) throws Exception {
        String modelName = MODEL_NAME_TEMPLATE + new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());
        return this.importContent(parent, content, modelName);
    }

    protected ConnectorNode importContent(ConnectorNode parent, String content, String modelName) throws Exception {
        this.getSignavioClient().importBpmnXml(parent.getId(), content, modelName);
        return this.getChildNodeByName(parent, modelName);
    }

    @Secured
    public List<ConnectorNode> importSignavioArchive(ConnectorNode parentFolder, String signavioArchive) throws Exception {
        this.getSignavioClient().importSignavioArchive(parentFolder.getId(), signavioArchive);
        return this.getChildren(parentFolder);
    }

    private ConnectorNode getChildNodeByName(ConnectorNode parent, String nodeName) {
        List<ConnectorNode> children = this.getChildren(parent);
        for (ConnectorNode connectorNode : children) {
            if (!connectorNode.getLabel().equals(nodeName)) continue;
            return connectorNode;
        }
        throw new CycleException("A node named '" + nodeName + "' could not be found in '" + parent.getLabel() + "'.");
    }

    private String extractType(ConnectorNode node) {
        ConnectorNodeType t = node.getType();
        if (t != null) {
            if (t.isFile()) {
                return "model";
            }
            if (t.equals((Object)ConnectorNodeType.FOLDER)) {
                return "directory";
            }
        }
        throw new CycleException("The type of the selected node '" + node.getLabel() + "' could not be determined, so that the parent could not be loaded.");
    }

    protected SignavioClient getSignavioClient() {
        return this.signavioClient;
    }

    @Override
    public ConnectorNode getNode(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSupportsCommitMessage() {
        return true;
    }

    protected <T> T executeCommand(Command<T> command) {
        try {
            T result = command.execute();
            return result;
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 401) {
                throw new CycleException("Failed to authenticate (Status 401)", e);
            }
            throw new CycleException("Could not execute action", e);
        }
        catch (Exception e) {
            throw new CycleException("Could not perform operation " + command.getOperation(), e);
        }
    }

    protected static abstract class Command<T> {
        private String operation;

        protected Command(String operation) {
            this.operation = operation;
        }

        public String getOperation() {
            return this.operation;
        }

        public abstract T execute() throws Exception;
    }
}

