/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.service.mail;

import java.util.Arrays;
import javax.inject.Inject;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.camunda.bpm.cycle.configuration.CycleConfiguration;
import org.camunda.bpm.cycle.service.mail.MailServiceException;
import org.camunda.bpm.cycle.service.mail.spi.MailSessionProvider;
import org.springframework.stereotype.Component;

@Component
public class DefaultMailSessionProvider
implements MailSessionProvider {
    @Inject
    private CycleConfiguration configuration;

    @Override
    public Session lookupMailSession() {
        String mailSessionName = this.configuration.getMailSessionName();
        if (mailSessionName == null) {
            return this.tryAutoDetectMailSession();
        }
        return this.performLookup(mailSessionName);
    }

    protected Session performLookup(String mailSessionName) {
        try {
            return (Session)InitialContext.doLookup(mailSessionName);
        }
        catch (NamingException e) {
            throw new MailServiceException("Could not lookup mail session with name '" + mailSessionName + "'");
        }
    }

    protected Session tryAutoDetectMailSession() {
        Object[] mailSessionNames = this.getKnownDefaultMailSessionNames();
        for (int i = 0; i < mailSessionNames.length; ++i) {
            String mailSessionName = mailSessionNames[i];
            try {
                Session session = this.performLookup(mailSessionName);
                this.configuration.setMailSessionName(mailSessionName);
                return session;
            }
            catch (MailServiceException e) {
                continue;
            }
        }
        throw new MailServiceException("No mail session URL configured and could not autodetect mail session using names " + Arrays.toString(mailSessionNames));
    }

    protected String[] getKnownDefaultMailSessionNames() {
        String[] mailSessionNames = new String[]{"java:comp/env/mail/Session", "java:jboss/mail/Default"};
        return mailSessionNames;
    }

    @Override
    public void sendMail(Message msg, Session session) {
        try {
            Transport.send((Message)msg);
        }
        catch (MessagingException e) {
            throw new MailServiceException("Could not send message using the default Transport", e);
        }
    }
}

