/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.camunda.bpm.cycle.exception.CycleException;

public class IoUtil {
    public static boolean DEBUG;
    public static String DEBUG_DIR;
    private static final int BUFFERSIZE = 4096;

    public static byte[] readInputStream(InputStream inputStream, String inputStreamName) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[16384];
        try {
            int bytesRead = inputStream.read(buffer);
            while (bytesRead != -1) {
                outputStream.write(buffer, 0, bytesRead);
                bytesRead = inputStream.read(buffer);
            }
        }
        catch (Exception e) {
            throw new CycleException("Couldn't read input stream " + inputStreamName, e);
        }
        return outputStream.toByteArray();
    }

    public static String readFileAsString(String filePath) {
        byte[] buffer = new byte[(int)IoUtil.getFile(filePath).length()];
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(IoUtil.getFile(filePath)));
            inputStream.read(buffer);
        }
        catch (Exception e) {
            try {
                throw new CycleException("Couldn't read file " + filePath + ": " + e.getMessage());
            }
            catch (Throwable throwable) {
                IoUtil.closeSilently(inputStream);
                throw throwable;
            }
        }
        IoUtil.closeSilently((InputStream)inputStream);
        return new String(buffer);
    }

    public static InputStream readFileAsInputStream(String absoluteClassPath) {
        InputStream inputStream = null;
        inputStream = IoUtil.class.getClass().getResourceAsStream(absoluteClassPath);
        if (inputStream == null) {
            throw new CycleException("Unable to read " + absoluteClassPath + " as inputstream.");
        }
        return inputStream;
    }

    public static File getFile(String filePath) {
        URL url = IoUtil.class.getClassLoader().getResource(filePath);
        try {
            return new File(url.toURI());
        }
        catch (Exception e) {
            throw new CycleException("Couldn't get file " + filePath + ": " + e.getMessage());
        }
    }

    public static void writeStringToFile(String content, String filePath) {
        BufferedOutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(IoUtil.getFile(filePath)));
            outputStream.write(content.getBytes());
            outputStream.flush();
        }
        catch (Exception e) {
            try {
                throw new CycleException("Couldn't write file " + filePath, e);
            }
            catch (Throwable throwable) {
                IoUtil.closeSilently(outputStream);
                throw throwable;
            }
        }
        IoUtil.closeSilently((OutputStream)outputStream);
    }

    public static void writeStringToFileIfDebug(String content, String filename, String suffix) {
        if (DEBUG) {
            String filePath = "";
            if (DEBUG_DIR != null && DEBUG_DIR.length() > 0) {
                filePath = DEBUG_DIR + System.getProperty("file.separator");
                File debugDirectory = new File(filePath);
                if (!debugDirectory.exists() && !debugDirectory.mkdirs()) {
                    throw new RuntimeException("Unable to create debugDirectory: " + debugDirectory.getAbsolutePath());
                }
                filePath = filePath + filename + "." + new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS_").format(new Date()) + suffix;
                try {
                    FileWriter writer = new FileWriter(filePath);
                    writer.write(content);
                    writer.flush();
                    writer.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to write debug file: " + filePath, e);
                }
            }
        }
    }

    public static void closeSilently(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeSilently(InputStream ... streams) {
        for (InputStream is : streams) {
            IoUtil.closeSilently(is);
        }
    }

    public static void closeSilently(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeSilently(OutputStream ... streams) {
        for (OutputStream os : streams) {
            IoUtil.closeSilently(os);
        }
    }

    public static int copyBytes(InputStream in, OutputStream out) throws IOException {
        if (in == null || out == null) {
            throw new IllegalArgumentException("In/OutStream cannot be null");
        }
        try {
            int bytesRead;
            int total = 0;
            byte[] buffer = new byte[4096];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                total += bytesRead;
            }
            int n = total;
            return n;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static String toString(InputStream input) throws IOException {
        return IOUtils.toString((InputStream)input);
    }

    public static String toString(InputStream input, String encoding) throws IOException {
        return IOUtils.toString((InputStream)input, (String)encoding);
    }

    public static InputStream toInputStream(String result, String encoding) {
        try {
            return new ByteArrayInputStream(result.getBytes(encoding));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Unsupported encoding", ex);
        }
    }
}

