/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.connector.test.util;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;

public class RepositoryUtil {
    public static String createVFSRepository(File file) throws IOException {
        RepositoryUtil.clean(file);
        return file.getAbsolutePath();
    }

    public static void clean(File directory) throws IOException {
        if (directory.exists()) {
            if (directory.isDirectory()) {
                FileUtils.deleteDirectory((File)directory);
            } else {
                throw new IllegalArgumentException("Not a directory: " + directory);
            }
        }
        if (!directory.mkdirs()) {
            throw new IllegalArgumentException("Could not clean: " + directory);
        }
    }

    public static String createSVNRepository(File directory) throws IOException, SVNException {
        RepositoryUtil.clean(directory);
        SVNURL url = SVNRepositoryFactory.createLocalRepository((File)directory, (boolean)true, (boolean)false);
        return url.toString();
    }
}

