/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.connector;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.camunda.bpm.cycle.aspect.LoginAspect;
import org.camunda.bpm.cycle.aspect.ThreadsafeAspect;
import org.camunda.bpm.cycle.connector.Connector;
import org.camunda.bpm.cycle.connector.ConnectorCache;
import org.camunda.bpm.cycle.connector.ConnectorNode;
import org.camunda.bpm.cycle.connector.ConnectorStatus;
import org.camunda.bpm.cycle.entity.ConnectorConfiguration;
import org.camunda.bpm.cycle.exception.CycleException;
import org.camunda.bpm.cycle.repository.ConnectorConfigurationRepository;
import org.springframework.aop.aspectj.annotation.AspectJProxyFactory;
import org.springframework.stereotype.Component;

@Component
public class ConnectorRegistry {
    private static final Logger logger = Logger.getLogger(ConnectorRegistry.class.getSimpleName());
    @Inject
    private LoginAspect loginAspect;
    @Inject
    private ThreadsafeAspect threadsafeAspect;
    private ConnectorCache cache;
    @Inject
    private List<ConnectorConfiguration> connectorDefinitions;
    @Inject
    private ConnectorConfigurationRepository connectorConfigurationRepository;

    @Inject
    public void setConnectorCache(ConnectorCache cache) {
        this.cache = cache;
    }

    public List<ConnectorConfiguration> getConnectorDefinitions() {
        return this.connectorDefinitions;
    }

    public ConnectorConfiguration getConnectorDefinition(Class<? extends Connector> cls) {
        for (ConnectorConfiguration definition : this.connectorDefinitions) {
            if (!definition.getConnectorClass().equals(cls.getName())) continue;
            return definition;
        }
        return null;
    }

    private ConnectorConfiguration getConnectorConfiguration(long connectorId) {
        for (ConnectorConfiguration c : this.getConnectorConfigurations()) {
            if (c.getId() != connectorId) continue;
            return c;
        }
        return null;
    }

    public List<ConnectorConfiguration> getConnectorConfigurations() {
        return this.connectorConfigurationRepository.findAll();
    }

    public List<ConnectorConfiguration> getConnectorConfigurations(Class<? extends Connector> cls) {
        return this.connectorConfigurationRepository.findByConnectorClass(cls.getName());
    }

    public Connector getConnector(Class<? extends Connector> cls) {
        List configs = this.getConnectorConfigurations(cls);
        if (!configs.isEmpty()) {
            return this.getConnector(((ConnectorConfiguration)configs.get(0)).getId().longValue());
        }
        return null;
    }

    public synchronized Connector getConnector(long connectorId) {
        Connector connector = this.cache.get(connectorId);
        if (connector == null) {
            connector = this.instantiateConnector(connectorId);
            this.cache.put(connectorId, connector);
        }
        return connector;
    }

    public ConnectorCache getCache() {
        return this.cache;
    }

    public List<Connector> getConnectors() {
        for (ConnectorConfiguration c : this.getConnectorConfigurations()) {
            this.getConnector(c.getId().longValue());
        }
        return new ArrayList<Connector>(this.cache.values());
    }

    private Connector instantiateConnector(long connectorId) {
        ConnectorConfiguration config = this.getConnectorConfiguration(connectorId);
        if (config == null) {
            return null;
        }
        return this.instantiateConnector(config);
    }

    Connector instantiateConnector(ConnectorConfiguration config) {
        return this.instantiateConnector(config, true);
    }

    private Connector instantiateConnector(ConnectorConfiguration config, boolean addLoginAspect) {
        try {
            AspectJProxyFactory factory = new AspectJProxyFactory(Class.forName(config.getConnectorClass()).newInstance());
            if (addLoginAspect) {
                factory.addAspect((Object)this.loginAspect);
            }
            factory.addAspect((Object)this.threadsafeAspect);
            Connector instance = (Connector)factory.getProxy();
            instance.setConfiguration(config);
            instance.init();
            return instance;
        }
        catch (Exception e) {
            throw new CycleException("Could not init connector", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectorStatus testConnectorConfiguration(ConnectorConfiguration config) {
        Connector connector = null;
        try {
            connector = this.instantiateConnector(config, true);
            ConnectorStatus connectorStatus = this.executeTest(connector);
            return connectorStatus;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error while testing connector configuration: " + config.getName(), e);
            ConnectorStatus connectorStatus = ConnectorStatus.inError((Exception)e);
            return connectorStatus;
        }
        finally {
            if (connector != null) {
                connector.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectorStatus testConnectorConfiguration(ConnectorConfiguration config, String username, String password) {
        Connector connector = null;
        try {
            connector = this.instantiateConnector(config, false);
            connector.login(username, password);
            ConnectorStatus connectorStatus = this.executeTest(connector);
            return connectorStatus;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error while testing connector configuration: " + config.getName(), e);
            ConnectorStatus connectorStatus = ConnectorStatus.inError((Exception)e);
            return connectorStatus;
        }
        finally {
            if (connector != null) {
                connector.dispose();
            }
        }
    }

    private ConnectorStatus executeTest(Connector connector) {
        try {
            ConnectorNode root = connector.getRoot();
            connector.getChildren(root);
            return ConnectorStatus.ok();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error while testing connector configuration: " + connector.getConfiguration().getName(), e);
            return ConnectorStatus.inError((Exception)e);
        }
    }
}

