/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.entity;

import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.camunda.bpm.cycle.connector.ConnectorNode;
import org.camunda.bpm.cycle.connector.ConnectorNodeType;
import org.camunda.bpm.cycle.entity.AbstractEntity;
import org.camunda.bpm.cycle.entity.BpmnDiagram;

@Entity
@Table(name="cy_bpmn_diagram")
public class BpmnDiagram
extends AbstractEntity {
    private static final long serialVersionUID = 1L;
    private String modeler;
    private String diagramPath;
    @Enumerated(value=EnumType.STRING)
    private Status status;
    private Long connectorId;
    private String label;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastModified;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastSync;

    public BpmnDiagram() {
    }

    public BpmnDiagram(String modeler, String diagramPath, Long connectorId) {
        this.modeler = modeler;
        this.diagramPath = diagramPath;
        this.connectorId = connectorId;
    }

    public BpmnDiagram(String modeler, ConnectorNode connectorNode) {
        this.modeler = modeler;
        this.diagramPath = connectorNode.getId();
        this.connectorId = connectorNode.getConnectorId();
    }

    public String getDiagramPath() {
        return this.diagramPath;
    }

    public void setDiagramPath(String diagramPath) {
        this.diagramPath = diagramPath;
    }

    public void setModeler(String modeler) {
        this.modeler = modeler;
    }

    public String getModeler() {
        return this.modeler;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Long getConnectorId() {
        return this.connectorId;
    }

    public void setConnectorId(Long connectorId) {
        this.connectorId = connectorId;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public Date getLastSync() {
        return this.lastSync;
    }

    public void setLastSync(Date lastSync) {
        this.lastSync = lastSync;
    }

    public ConnectorNode getConnectorNode() {
        if (this.diagramPath != null) {
            return new ConnectorNode(this.diagramPath, this.label, this.connectorId, ConnectorNodeType.BPMN_FILE);
        }
        return null;
    }
}

