/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.web.service;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.cycle.web.jaxrs.ext.JaxRsUtil;

public class AbstractRestService {
    @Context
    private UriInfo uriInfo;

    protected Response redirectTo(String uri) {
        return JaxRsUtil.createResponse().status(Response.Status.SEE_OTHER).location(this.uriInfo.getBaseUriBuilder().path(uri).build(new Object[0])).build();
    }

    protected WebApplicationException notFound(String message) {
        return this.createWebApplicationException(message, Response.Status.NOT_FOUND);
    }

    protected WebApplicationException badRequest(String message) {
        return this.createWebApplicationException(message, Response.Status.BAD_REQUEST);
    }

    protected WebApplicationException notAllowed(String message) {
        return this.createWebApplicationException(message, Response.Status.FORBIDDEN);
    }

    protected WebApplicationException internalServerError(String message) {
        return this.createWebApplicationException(message, Response.Status.INTERNAL_SERVER_ERROR);
    }

    private WebApplicationException createWebApplicationException(String message, Response.Status status) {
        Response.ResponseBuilder responseBuilder = JaxRsUtil.createResponse().status(status);
        if (message == null) {
            responseBuilder.entity((Object)message);
        }
        Response response = responseBuilder.build();
        return new WebApplicationException(response);
    }
}

