/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.web.service.resource;

import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.camunda.bpm.cycle.connector.Connector;
import org.camunda.bpm.cycle.connector.ConnectorNode;
import org.camunda.bpm.cycle.connector.ConnectorNodeType;
import org.camunda.bpm.cycle.connector.ConnectorRegistry;
import org.camunda.bpm.cycle.connector.ContentInformation;
import org.camunda.bpm.cycle.entity.AbstractEntity;
import org.camunda.bpm.cycle.entity.BpmnDiagram;
import org.camunda.bpm.cycle.repository.BpmnDiagramRepository;
import org.camunda.bpm.cycle.web.dto.BpmnDiagramDTO;
import org.camunda.bpm.cycle.web.dto.BpmnDiagramStatusDTO;
import org.camunda.bpm.cycle.web.dto.ConnectorNodeDTO;
import org.camunda.bpm.cycle.web.service.AbstractRestService;
import org.camunda.bpm.cycle.web.service.resource.ConnectorService;
import org.springframework.transaction.annotation.Transactional;

@Path(value="secured/resource/diagram")
public class BpmnDiagramService
extends AbstractRestService {
    private static final int OFFSET = 5000;
    private static Logger log = Logger.getLogger(BpmnDiagramService.class.getName());
    @Inject
    private BpmnDiagramRepository bpmnDiagramRepository;
    @Inject
    private ConnectorService connectorService;
    private ConnectorRegistry connectorRegistry;

    @Inject
    public void setConnectorRegistry(ConnectorRegistry connectorRegistry) {
        this.connectorRegistry = connectorRegistry;
    }

    @GET
    @Path(value="{id}")
    public BpmnDiagramDTO get(@PathParam(value="id") long id) {
        return BpmnDiagramDTO.wrap((BpmnDiagram)this.getDiagramById(id));
    }

    @GET
    @Path(value="{id}/image")
    public Response getImage(@PathParam(value="id") long id) {
        Date imageLastModified;
        BpmnDiagram diagram = this.getDiagramById(id);
        ConnectorNode node = diagram.getConnectorNode();
        ContentInformation imageInformation = this.connectorService.getContentInfo(node.getConnectorId().longValue(), node.getId(), ConnectorNodeType.PNG_FILE);
        if (!imageInformation.exists()) {
            throw this.notFound("no image");
        }
        Date diagramLastModified = diagram.getLastModified();
        if (diagramLastModified != null && (imageLastModified = imageInformation.getLastModified()) != null && imageLastModified.getTime() + 5000L < diagramLastModified.getTime()) {
            throw this.notFound("no up to date image");
        }
        return this.connectorService.getTypedContent(node.getConnectorId().longValue(), node.getId(), ConnectorNodeType.PNG_FILE);
    }

    @POST
    @Path(value="{id}")
    @Transactional
    public BpmnDiagramDTO update(BpmnDiagramDTO data) {
        return BpmnDiagramDTO.wrap((BpmnDiagram)this.createOrUpdate(data));
    }

    @POST
    public BpmnDiagramDTO create(BpmnDiagramDTO data) {
        return BpmnDiagramDTO.wrap((BpmnDiagram)this.createOrUpdate(data));
    }

    @Transactional
    public BpmnDiagram createOrUpdate(BpmnDiagramDTO data) {
        BpmnDiagram diagram;
        if (data.getId() == null) {
            diagram = new BpmnDiagram();
            diagram.setStatus(BpmnDiagram.Status.UNSPECIFIED);
        } else {
            diagram = this.getDiagramById(data.getId().longValue());
        }
        this.update(diagram, data);
        return (BpmnDiagram)this.bpmnDiagramRepository.saveAndFlush((AbstractEntity)diagram);
    }

    private void update(BpmnDiagram diagram, BpmnDiagramDTO data) {
        diagram.setModeler(data.getModeler());
        ConnectorNodeDTO node = data.getConnectorNode();
        diagram.setLabel(node.getLabel());
        diagram.setConnectorId(node.getConnectorId());
        diagram.setDiagramPath(node.getId());
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="modelerNames")
    public List<String> getModelerNames() {
        return this.bpmnDiagramRepository.findAllModelerNames();
    }

    @GET
    @Transactional
    @Path(value="{id}/syncStatus")
    public BpmnDiagramStatusDTO synchronizationStatus(@PathParam(value="id") long id) {
        BpmnDiagram diagram = this.getDiagramById(id);
        ConnectorNode node = diagram.getConnectorNode();
        Connector connector = this.connectorRegistry.getConnector(node.getConnectorId().longValue());
        if (connector == null) {
            BpmnDiagramStatusDTO notFoundStatus = new BpmnDiagramStatusDTO(diagram.getId().longValue(), BpmnDiagram.Status.UNAVAILABLE, null);
            notFoundStatus.setLastUpdated(new Date());
            return notFoundStatus;
        }
        BpmnDiagram.Status status = BpmnDiagram.Status.UNSPECIFIED;
        Date lastModified = null;
        ContentInformation contentInfo = connector.getContentInformation(node);
        status = !contentInfo.exists() ? BpmnDiagram.Status.UNAVAILABLE : ((lastModified = contentInfo.getLastModified()) != null && diagram.getLastSync() != null ? (lastModified.getTime() <= diagram.getLastSync().getTime() ? BpmnDiagram.Status.SYNCED : BpmnDiagram.Status.OUT_OF_SYNC) : BpmnDiagram.Status.UNSPECIFIED);
        diagram.setLastModified(lastModified);
        BpmnDiagramStatusDTO statusDTO = new BpmnDiagramStatusDTO(diagram.getId().longValue(), status, diagram.getLastModified());
        statusDTO.setLastUpdated(new Date());
        return statusDTO;
    }

    protected BpmnDiagram getDiagramById(long id) {
        BpmnDiagram diagram = (BpmnDiagram)this.bpmnDiagramRepository.findById(id);
        if (diagram == null) {
            throw this.notFound("diagram not found");
        }
        return diagram;
    }
}

