/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.security.web;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.camunda.bpm.security.UserIdentity;
import org.camunda.bpm.security.web.SecurityWrappedRequest;

public class SecurityWrappedRequest
extends HttpServletRequestWrapper {
    private final UserIdentity identity;
    private final UserPrincipal principal;

    public SecurityWrappedRequest(HttpServletRequest request, UserIdentity identity) {
        super(request);
        this.identity = identity;
        this.principal = new UserPrincipal(identity.getName());
    }

    public boolean isUserInRole(String role) {
        if ("user".equals(role)) {
            return true;
        }
        if ("admin".equals(role)) {
            return this.identity.isAdmin();
        }
        return false;
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }
}

