/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.security.web.jaxrs;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.camunda.bpm.cycle.web.dto.WebExceptionDTO;
import org.camunda.bpm.cycle.web.jaxrs.ext.JaxRsUtil;
import org.camunda.bpm.security.MissingPrivilegesException;
import org.camunda.bpm.security.SecurityException;
import org.camunda.bpm.security.UnauthorizedException;
import org.camunda.bpm.security.web.util.WebUtil;

@Provider
public class SecurityExceptionMapper
implements ExceptionMapper<SecurityException> {
    @Context
    private HttpServletRequest request;

    public Response toResponse(SecurityException exception) {
        Response.Status status = Response.Status.NOT_FOUND;
        String errorPage = null;
        if (exception instanceof MissingPrivilegesException) {
            status = Response.Status.FORBIDDEN;
            errorPage = "tpl:error/forbidden";
        } else if (exception instanceof UnauthorizedException) {
            errorPage = "tpl:error/forbidden";
            status = Response.Status.UNAUTHORIZED;
        }
        Response.ResponseBuilder builder = JaxRsUtil.createResponse().status(status);
        if (WebUtil.isAjax((HttpServletRequest)this.request)) {
            builder.entity((Object)WebExceptionDTO.wrap((Exception)exception, (Response.Status)status));
        } else {
            builder.entity((Object)errorPage);
        }
        return builder.build();
    }
}

