/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.connector.signavio;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.ParseException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.fluent.Content;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Form;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.SyncBasicHttpParams;
import org.apache.http.util.EntityUtils;
import org.camunda.bpm.cycle.connector.signavio.SignavioClient;
import org.camunda.bpm.cycle.exception.CycleException;
import org.camunda.bpm.cycle.util.IoUtil;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class SignavioClient {
    private static final Logger logger = Logger.getLogger(SignavioClient.class.getName());
    static final String SLASH_CHAR = "/";
    private static final String UTF_8 = "UTF-8";
    private static final int MAX_OPEN_CONNECTIONS_TOTAL = 20;
    private static final int MAX_OPEN_CONNECTIONS_PER_ROUTE = 5;
    private static final int CONNECTION_IDLE_CLOSE = 2000;
    private static final int CONNECTION_TIMEOUT = 3000;
    private static final int CONNECTION_TTL = 5000;
    private static final int RETRIES_CONNECTION_EXCEPTION = 1;
    private static final String WARNING_SNIPPET = "<div id=\"warning\">([^<]+)</div>";
    private static final String LOGIN_URL_SUFFIX = "login";
    private static final String REPOSITORY_BACKEND_URL_SUFFIX = "p";
    public static final String MODEL_URL_SUFFIX = "model";
    public static final String DIRECTORY_URL_SUFFIX = "directory";
    private static final String BPMN2_0_IMPORT_SUFFIX = "bpmn2_0-import";
    private static final String SGX_IMPORT_SUFFIX = "zip-import";
    private static final String HEADER_SIGNAVIO_SECURITY_TOKEN = "x-signavio-id";
    private String configurationName;
    private String signavioBaseUrl;
    private String proxyUrl;
    private String proxyUsername;
    private String proxyPassword;
    private DefaultHttpClient apacheHttpClient;
    private Executor requestExecutor;
    private String securityToken;
    private String defaultCommitMessage;

    public SignavioClient(String configurationName, String signavioBaseUrl, String proxyUrl, String proxyUsername, String proxyPassword, String defaultCommitMessage) throws URISyntaxException {
        this.configurationName = configurationName;
        this.signavioBaseUrl = signavioBaseUrl;
        this.proxyUrl = proxyUrl;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.defaultCommitMessage = defaultCommitMessage;
        this.initHttpClient();
    }

    public boolean login(String username, String password) {
        Form loginForm = Form.form();
        loginForm.add("name", username);
        loginForm.add("password", password);
        loginForm.add("tokenonly", "true");
        Request request = Request.Post((URI)this.requestUrl(new String[]{LOGIN_URL_SUFFIX})).bodyForm((Iterable)loginForm.build(), Charset.forName(UTF_8));
        HttpResponse response = this.executeAndGetResponse(request);
        String responseResult = this.extractResponseResult(response);
        if (responseResult == null || responseResult.equals("")) {
            throw new CycleException("Could not login into connector '" + this.configurationName + "'. The user name and/or password might be incorrect.");
        }
        Matcher matcher = Pattern.compile(WARNING_SNIPPET).matcher(responseResult);
        if (matcher.find()) {
            String errorMessage = matcher.group(1);
            throw new CycleException("Could not login into connector '" + this.configurationName + "'. " + errorMessage);
        }
        if (responseResult.matches("[a-f0-9]{32}")) {
            this.securityToken = responseResult;
            logger.fine("SecurityToken: " + this.securityToken);
        }
        return true;
    }

    public String getChildren(String dir) {
        Request request = Request.Get((URI)this.requestUrl(new String[]{DIRECTORY_URL_SUFFIX, dir})).addHeader("accept", ContentType.APPLICATION_JSON.getMimeType());
        HttpResponse response = this.executeAndGetResponse(request);
        return this.extractResponseResult(response);
    }

    public InputStream getXmlContent(String model) {
        try {
            Request request = Request.Get((URI)this.requestUrl(new String[]{MODEL_URL_SUFFIX, model, "bpmn2_0_xml"})).addHeader("accept", ContentType.APPLICATION_XML.getMimeType());
            InputStream in = this.executeAndGetContent(request).asStream();
            return in;
        }
        catch (Exception e) {
            throw new CycleException(e.getMessage(), (Throwable)e);
        }
    }

    public InputStream getPngContent(String model) {
        try {
            Request request = Request.Get((URI)this.requestUrl(new String[]{MODEL_URL_SUFFIX, model, "png"})).addHeader("accept", ContentType.APPLICATION_XML.getMimeType());
            InputStream in = this.executeAndGetContent(request).asStream();
            return in;
        }
        catch (Exception e) {
            throw new CycleException(e.getMessage(), (Throwable)e);
        }
    }

    public String getInfo(String type, String id) {
        Request request = Request.Get((URI)this.requestUrl(new String[]{type, id, "info"})).addHeader("accept", ContentType.APPLICATION_JSON.getMimeType());
        HttpResponse response = this.executeAndGetResponse(request);
        return this.extractResponseResult(response);
    }

    public String getModelAsJson(String id) {
        Request request = Request.Get((URI)this.requestUrl(new String[]{MODEL_URL_SUFFIX, id, "json"})).addHeader("accept", ContentType.APPLICATION_JSON.getMimeType());
        HttpResponse response = this.executeAndGetResponse(request);
        return this.extractResponseResult(response);
    }

    public String getModelAsSVG(String id) {
        Request request = Request.Get((URI)this.requestUrl(new String[]{MODEL_URL_SUFFIX, id, "svg"})).addHeader("accept", ContentType.APPLICATION_JSON.getMimeType());
        HttpResponse response = this.executeAndGetResponse(request);
        return this.extractResponseResult(response);
    }

    public String delete(String type, String id) {
        Request request = Request.Delete((URI)this.requestUrl(new String[]{type, id})).addHeader("accept", ContentType.APPLICATION_JSON.getMimeType());
        HttpResponse response = this.executeAndGetResponse(request);
        return this.extractResponseResult(response);
    }

    public String createModel(String parentId, String label, String message) {
        if (message == null || message.length() == 0) {
            message = this.defaultCommitMessage;
        }
        Form createModelForm = this.constructModelForm(this.constructCreateModelParams(parentId, label, message));
        Request request = Request.Post((URI)this.requestUrl(new String[]{MODEL_URL_SUFFIX})).addHeader("accept", ContentType.APPLICATION_JSON.getMimeType()).bodyForm((Iterable)createModelForm.build(), Charset.forName(UTF_8));
        HttpResponse response = this.executeAndGetResponse(request);
        return this.extractResponseResult(response);
    }

    public String updateModel(String id, String label, String json, String svg, String parentId, String message) throws JSONException {
        if (message == null || message.length() == 0) {
            message = this.defaultCommitMessage;
        }
        Form updateModelForm = this.constructModelForm(this.constructUpdateModelParams(id, label, json, svg, parentId, message));
        Request request = Request.Put((URI)this.requestUrl(new String[]{MODEL_URL_SUFFIX, id})).addHeader("accept", ContentType.APPLICATION_JSON.getMimeType()).bodyForm((Iterable)updateModelForm.build(), Charset.forName(UTF_8));
        HttpResponse response = this.executeAndGetResponse(request);
        return this.extractResponseResult(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Map<String, String> constructCreateModelParams(String parentId, String label, String message) {
        HashMap<String, String> createModelParams = new HashMap<String, String>();
        InputStream emptyJson = null;
        try {
            createModelParams.put("id", UUID.randomUUID().toString().replace("-", ""));
            createModelParams.put("name", label);
            createModelParams.put("comment", message);
            createModelParams.put("description", "");
            createModelParams.put("parent", parentId);
            emptyJson = this.getClass().getClassLoader().getResourceAsStream("org/camunda/bpm/cycle/connector/emptyProcessModelTemplate.json");
            createModelParams.put("json_xml", new String(IoUtil.readInputStream((InputStream)emptyJson, (String)"emptyProcessModelTemplate.json"), UTF_8));
            createModelParams.put("svg_xml", "<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:oryx=\"http://oryx-editor.org\" id=\"sid-80D82B67-3B30-4B35-A6CB-16EEE17A719F\" width=\"50\" height=\"50\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:svg=\"http://www.w3.org/2000/svg\"><defs/><g stroke=\"black\" font-family=\"Verdana, sans-serif\" font-size-adjust=\"none\" font-style=\"normal\" font-variant=\"normal\" font-weight=\"normal\" line-heigth=\"normal\" font-size=\"12\"><g class=\"stencils\" transform=\"translate(25, 25)\"><g class=\"me\"/><g class=\"children\"/><g class=\"edge\"/></g></g></svg>");
        }
        catch (UnsupportedEncodingException e) {
            IoUtil.closeSilently(emptyJson);
            catch (Throwable throwable) {
                IoUtil.closeSilently(emptyJson);
                throw throwable;
            }
        }
        IoUtil.closeSilently((InputStream)emptyJson);
        return createModelParams;
    }

    private Map<String, String> constructUpdateModelParams(String id, String name, String json, String svg, String parentId, String message) throws JSONException {
        HashMap<String, String> updateModelParams = new HashMap<String, String>();
        if (id.startsWith(SLASH_CHAR)) {
            id = id.substring(1);
        }
        updateModelParams.put("id", id);
        if (name == null) {
            name = "";
        }
        updateModelParams.put("name", name);
        updateModelParams.put("json_xml", new JSONObject(json).toString());
        if (svg == null || svg.isEmpty()) {
            svg = "<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:oryx=\"http://oryx-editor.org\" id=\"sid-80D82B67-3B30-4B35-A6CB-16EEE17A719F\" width=\"50\" height=\"50\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:svg=\"http://www.w3.org/2000/svg\"><defs/><g stroke=\"black\" font-family=\"Verdana, sans-serif\" font-size-adjust=\"none\" font-style=\"normal\" font-variant=\"normal\" font-weight=\"normal\" line-heigth=\"normal\" font-size=\"12\"><g class=\"stencils\" transform=\"translate(25, 25)\"><g class=\"me\"/><g class=\"children\"/><g class=\"edge\"/></g></g></svg>";
        }
        updateModelParams.put("svg_xml", svg);
        updateModelParams.put("comment", message);
        updateModelParams.put("description", "");
        updateModelParams.put("parent", parentId);
        return updateModelParams;
    }

    private Form constructModelForm(Map<String, String> modelParams) {
        Form createModelForm = Form.form();
        if (modelParams.containsKey("id")) {
            createModelForm.add("id", modelParams.get("id"));
        }
        createModelForm.add("name", modelParams.get("name"));
        createModelForm.add("comment", modelParams.get("comment"));
        createModelForm.add("description", modelParams.get("description"));
        createModelForm.add("json_xml", modelParams.get("json_xml"));
        createModelForm.add("svg_xml", modelParams.get("svg_xml"));
        createModelForm.add("parent", "/directory" + modelParams.get("parent"));
        createModelForm.add("glossary_xml", new JSONArray().toString());
        createModelForm.add("namespace", "http://b3mn.org/stencilset/bpmn2.0#");
        createModelForm.add("type", "BPMN 2.0");
        return createModelForm;
    }

    public String createFolder(String name, String parent) {
        Form createFolderForm = Form.form();
        createFolderForm.add("name", name);
        createFolderForm.add("parent", "/directory" + parent);
        createFolderForm.add("description", "");
        Request request = Request.Post((URI)this.requestUrl(new String[]{DIRECTORY_URL_SUFFIX})).addHeader("accept", ContentType.APPLICATION_JSON.getMimeType()).bodyForm((Iterable)createFolderForm.build(), Charset.forName(UTF_8));
        HttpResponse response = this.executeAndGetResponse(request);
        return this.extractResponseResult(response);
    }

    public String importBpmnXml(String parentFolderId, String content, String modelName) throws ParseException, IOException {
        MultipartEntity multipartEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        multipartEntity.addPart(DIRECTORY_URL_SUFFIX, (ContentBody)new StringBody("/directory" + parentFolderId, Charset.forName(UTF_8)));
        ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes(UTF_8));
        InputStreamBody isb = new InputStreamBody((InputStream)in, modelName);
        multipartEntity.addPart("bpmn2_0file", (ContentBody)isb);
        Request request = Request.Post((URI)this.requestUrl(new String[]{BPMN2_0_IMPORT_SUFFIX})).addHeader("accept", ContentType.MULTIPART_FORM_DATA.getMimeType()).body((HttpEntity)multipartEntity);
        HttpResponse response = this.executeAndGetResponse(request);
        if (response.getStatusLine().getStatusCode() >= 400) {
            logger.severe("Import of BPMN XML failed in Signavio.");
            logger.severe("Error response from server: " + EntityUtils.toString((HttpEntity)response.getEntity(), (String)UTF_8));
            throw new CycleException("BPMN XML could not be imported: " + content);
        }
        String responseStream = this.extractResponseResult(response);
        if (responseStream != null && !responseStream.startsWith("[true]") && !responseStream.contains("\"errors\":[]")) {
            throw new CycleException("BPMN XML could not be imported because of model errors: " + responseStream);
        }
        return responseStream;
    }

    public String importSignavioArchive(String parentFolderId, String signavioArchive) throws ParseException, IOException {
        MultipartEntity multipartEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        multipartEntity.addPart(DIRECTORY_URL_SUFFIX, (ContentBody)new StringBody("/directory" + parentFolderId, Charset.forName(UTF_8)));
        multipartEntity.addPart("signavio-id", (ContentBody)new StringBody(UUID.randomUUID().toString(), Charset.forName(UTF_8)));
        multipartEntity.addPart("file", (ContentBody)new FileBody(new File(signavioArchive)));
        Request request = Request.Post((URI)this.requestUrl(new String[]{SGX_IMPORT_SUFFIX})).addHeader("accept", ContentType.MULTIPART_FORM_DATA.getMimeType()).body((HttpEntity)multipartEntity);
        HttpResponse response = this.executeAndGetResponse(request);
        if (response.getStatusLine().getStatusCode() >= 400) {
            logger.severe("Import of BPMN XML failed in Signavio.");
            logger.severe("Error response from server: " + EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.forName(UTF_8)));
            throw new CycleException("BPMN XML could not be imported: " + signavioArchive);
        }
        return this.extractResponseResult(response);
    }

    private void initHttpClient() throws URISyntaxException {
        SchemeRegistry schemeRegistry = SchemeRegistryFactory.createDefault();
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            1 trustAllManager = new /* Unavailable Anonymous Inner Class!! */;
            sslContext.init(new KeyManager[0], new TrustManager[]{trustAllManager}, new SecureRandom());
            SSLContext.setDefault(sslContext);
            SSLSocketFactory sslSF = new SSLSocketFactory(sslContext, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            sslSF.setHostnameVerifier((X509HostnameVerifier)new /* Unavailable Anonymous Inner Class!! */);
            schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)sslSF));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to modify SSLSocketFactory to allow self-signed certificates.", e);
        }
        SyncBasicHttpParams params = new SyncBasicHttpParams();
        DefaultHttpClient.setDefaultHttpParams((HttpParams)params);
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)3000);
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)params, (boolean)true);
        HttpConnectionParams.setLinger((HttpParams)params, (int)5000);
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager(schemeRegistry, 5000L, TimeUnit.MILLISECONDS);
        connectionManager.setDefaultMaxPerRoute(5);
        connectionManager.setMaxTotal(20);
        this.apacheHttpClient = new DefaultHttpClient((ClientConnectionManager)connectionManager, (HttpParams)params);
        this.configureProxy();
        this.apacheHttpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.apacheHttpClient.addRequestInterceptor((HttpRequestInterceptor)new /* Unavailable Anonymous Inner Class!! */);
        this.apacheHttpClient.addResponseInterceptor((HttpResponseInterceptor)new /* Unavailable Anonymous Inner Class!! */);
        this.apacheHttpClient.setReuseStrategy((ConnectionReuseStrategy)new NoConnectionReuseStrategy());
        this.requestExecutor = Executor.newInstance((HttpClient)this.apacheHttpClient);
    }

    private void configureProxy() throws URISyntaxException {
        if (this.proxyUrl != null && !this.proxyUrl.isEmpty()) {
            URI proxyURI = new URI(this.proxyUrl);
            String proxyHost = proxyURI.getHost();
            int proxyPort = proxyURI.getPort();
            this.apacheHttpClient.getParams().setParameter("http.route.default-proxy", (Object)new HttpHost(proxyHost, proxyPort));
            if (this.proxyUsername != null && !this.proxyUsername.isEmpty() && this.proxyPassword != null && !this.proxyPassword.isEmpty()) {
                this.apacheHttpClient.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new UsernamePasswordCredentials(this.proxyUsername, this.proxyPassword));
            }
            logger.fine("Configured signavio client with proxy settings: url: " + this.proxyUrl + ", proxyUsername: " + this.proxyUsername);
        }
    }

    protected Content executeAndGetContent(Request request) {
        try {
            return this.requestExecutor.execute(request).returnContent();
        }
        catch (Exception e) {
            throw new CycleException("Connector '" + this.configurationName + "'", (Throwable)e);
        }
    }

    protected HttpResponse executeAndGetResponse(Request request) {
        try {
            return this.requestExecutor.execute(request).returnResponse();
        }
        catch (Exception e) {
            throw new CycleException("Connector '" + this.configurationName + "'", (Throwable)e);
        }
    }

    private URI signavioBackendBaseURI() throws URISyntaxException {
        URIBuilder builder = new URIBuilder(this.signavioBaseUrl);
        builder.setPath("/p");
        return builder.build();
    }

    private URI requestUrl(String ... pathArgs) {
        try {
            URIBuilder builder = new URIBuilder(this.signavioBackendBaseURI());
            StringBuffer sb = new StringBuffer();
            for (String pathArg : pathArgs) {
                if (!pathArg.startsWith(SLASH_CHAR)) {
                    sb.append(SLASH_CHAR);
                }
                sb.append(pathArg);
            }
            builder.setPath(builder.getPath() + sb.toString());
            URI requestURI = builder.build();
            logger.fine(requestURI.toString());
            return requestURI;
        }
        catch (URISyntaxException e) {
            throw new CycleException("Failed to construct url for signavio request.", (Throwable)e);
        }
    }

    public void dispose() {
        this.apacheHttpClient.getConnectionManager().shutdown();
        this.requestExecutor = null;
    }

    private String extractResponseResult(HttpResponse response) {
        try {
            String payload = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.forName(UTF_8));
            if (payload.contains("An error occurred (unauthorized)")) {
                throw new CycleException("Could not login into connector '" + this.configurationName + "'. The user name and/or password might be incorrect.");
            }
            String string = payload;
            return string;
        }
        catch (IOException e) {
            throw new CycleException(e.getMessage(), (Throwable)e);
        }
        finally {
            HttpClientUtils.closeQuietly((HttpResponse)response);
        }
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static /* synthetic */ String access$100(SignavioClient x0) {
        return x0.securityToken;
    }
}

