/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.repository;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.camunda.bpm.cycle.entity.AbstractEntity;
import org.camunda.bpm.cycle.util.ClassUtil;
import org.springframework.transaction.annotation.Transactional;

public class AbstractRepository<T extends AbstractEntity> {
    @PersistenceContext
    protected EntityManager em;
    private Class<T> entityClass = ClassUtil.extractParameterizedType(this.getClass());

    protected AbstractRepository() {
    }

    @Transactional
    public T saveAndFlush(T entity) {
        if (!this.em.contains(entity)) {
            this.em.persist(entity);
        }
        this.em.flush();
        return entity;
    }

    @Transactional
    public void delete(Long id) {
        AbstractEntity e = (AbstractEntity)this.em.find(this.entityClass, (Object)id);
        if (e != null) {
            this.em.remove((Object)e);
        }
    }

    @Transactional
    public void delete(T entity) {
        if (this.em.contains(entity)) {
            this.em.remove(entity);
        } else {
            this.delete(entity.getId());
        }
    }

    public T findById(long id) {
        return (T)((AbstractEntity)this.em.find(this.entityClass, (Object)id));
    }

    public List<T> findAll() {
        return this.em.createQuery("SELECT e FROM " + this.entityClass.getSimpleName() + " e", this.entityClass).getResultList();
    }

    public long countAll() {
        return (Long)this.em.createQuery("SELECT COUNT(e) FROM " + this.entityClass.getSimpleName() + " e", Long.class).getSingleResult();
    }

    @Transactional
    public int deleteAll() {
        return this.em.createQuery("DELETE FROM " + this.entityClass.getSimpleName()).executeUpdate();
    }
}

