/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.repository;

import java.util.List;
import org.camunda.bpm.cycle.entity.ConnectorCredentials;
import org.camunda.bpm.cycle.repository.AbstractRepository;
import org.springframework.stereotype.Repository;

@Repository
public class ConnectorCredentialsRepository
extends AbstractRepository<ConnectorCredentials> {
    public List<ConnectorCredentials> findFetchConfigurationByUserId(Long userId) {
        return this.em.createQuery("SELECT c FROM ConnectorCredentials c JOIN FETCH c.user JOIN FETCH c.connectorConfiguration WHERE c.user.id = :userId", ConnectorCredentials.class).setParameter("userId", (Object)userId).getResultList();
    }

    public ConnectorCredentials findFetchConfigurationById(Long id) {
        return (ConnectorCredentials)this.em.createQuery("SELECT c FROM ConnectorCredentials c JOIN FETCH c.user JOIN FETCH c.connectorConfiguration WHERE c.id = :id", ConnectorCredentials.class).setParameter("id", (Object)id).getSingleResult();
    }

    public ConnectorCredentials findFetchAllByUserIdAndConnectorId(long userId, long connectorId) {
        return (ConnectorCredentials)this.em.createQuery("SELECT c FROM ConnectorCredentials c JOIN FETCH c.user JOIN FETCH c.connectorConfiguration WHERE c.user.id = :userId AND c.connectorConfiguration.id = :connectorId", ConnectorCredentials.class).setParameter("userId", (Object)userId).setParameter("connectorId", (Object)connectorId).getSingleResult();
    }

    public ConnectorCredentials findFetchAllByUsernameAndConnectorId(String username, long connectorId) {
        return (ConnectorCredentials)this.em.createQuery("SELECT c FROM ConnectorCredentials c JOIN FETCH c.user JOIN FETCH c.connectorConfiguration WHERE c.user.name = :username AND c.connectorConfiguration.id = :connectorId", ConnectorCredentials.class).setParameter("username", (Object)username).setParameter("connectorId", (Object)connectorId).getSingleResult();
    }
}

