/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class BpmnNamespaceContext
implements NamespaceContext {
    public static final String BPMN = "bpmn";
    public static final String BPMNDI = "bpmndi";
    public static final String OMGDC = "omgdc";
    public static final String OMGDI = "omgdi";
    public static final String BPMN_NAMESPACE_URI = "http://www.omg.org/spec/BPMN/20100524/MODEL";
    public static final String BPMN_DI_NAMESPACE_URI = "http://www.omg.org/spec/BPMN/20100524/DI";
    public static final String OMG_DC_NAMESPACE_URI = "http://www.omg.org/spec/DD/20100524/DC";
    public static final String OMG_DI_NAMESPACE_URI = "http://www.omg.org/spec/DD/20100524/DI";
    protected Map<String, String> namespaces = new HashMap();

    public BpmnNamespaceContext() {
        this.namespaces.put(BPMN, BPMN_NAMESPACE_URI);
        this.namespaces.put(BPMNDI, BPMN_DI_NAMESPACE_URI);
        this.namespaces.put(OMGDC, OMG_DC_NAMESPACE_URI);
        this.namespaces.put(OMGDI, OMG_DI_NAMESPACE_URI);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix.equals(BPMN)) {
            return BPMN_NAMESPACE_URI;
        }
        if (prefix.equals(BPMNDI)) {
            return BPMN_DI_NAMESPACE_URI;
        }
        if (prefix.equals(OMGDC)) {
            return OMG_DC_NAMESPACE_URI;
        }
        if (prefix.equals(OMGDI)) {
            return OMG_DI_NAMESPACE_URI;
        }
        return "";
    }

    @Override
    public String getPrefix(String namespace) {
        if (namespace.equals(BPMN_NAMESPACE_URI)) {
            return BPMN;
        }
        if (namespace.equals(BPMN_DI_NAMESPACE_URI)) {
            return BPMNDI;
        }
        if (namespace.equals(OMG_DC_NAMESPACE_URI)) {
            return OMGDC;
        }
        if (namespace.equals(OMG_DI_NAMESPACE_URI)) {
            return OMGDI;
        }
        return null;
    }

    public Iterator getPrefixes(String namespace) {
        return null;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }
}

