/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.web.dto;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.ws.rs.core.Response;
import org.camunda.bpm.web.WebException;

public class WebExceptionDTO {
    private String message;
    private String cause;
    private String stacktrace;
    private Response.Status status;

    public WebExceptionDTO() {
    }

    public WebExceptionDTO(Response.Status status, String message, Throwable cause) {
        this.message = message;
        if (cause != null) {
            this.cause = cause.getClass().getName();
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            cause.printStackTrace(printer);
            printer.flush();
            this.stacktrace = writer.toString();
        }
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCause() {
        return this.cause;
    }

    public String getStacktrace() {
        return this.stacktrace;
    }

    public Response.Status getStatus() {
        return this.status;
    }

    public static WebExceptionDTO wrap(WebException exception) {
        return new WebExceptionDTO(exception.getStatus(), exception.getMessage(), exception.getCause());
    }

    public static WebExceptionDTO wrap(Exception exception, Response.Status status) {
        return new WebExceptionDTO(status, exception.getMessage(), exception.getCause());
    }
}

