/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.camunda.bpm.cycle.repository.UserRepository;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class InitialConfigurationFilter
implements Filter {
    private WebApplicationContext context;
    private UserRepository userRepository;

    public void init(FilterConfig config) throws ServletException {
        this.context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)config.getServletContext());
        this.userRepository = (UserRepository)this.context.getBean(UserRepository.class);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.filterInitialConfiguration((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    void filterInitialConfiguration(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.isAtLeastOneUserConfigured() && !this.isConfigurationPage(request)) {
            this.redirectToConfigurationPage(request, response);
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected boolean isAtLeastOneUserConfigured() {
        return this.userRepository.countAll() > 0L;
    }

    private void redirectToConfigurationPage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(request.getContextPath() + "/" + "app/first-time-setup");
    }

    private boolean isConfigurationPage(HttpServletRequest request) {
        return request.getRequestURI().matches(".*/app/first-time-setup");
    }
}

