/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.web.jaxrs.ext;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.springframework.context.ApplicationContext;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring3.context.SpringWebContext;
import org.xnap.commons.i18n.I18n;

@Provider
@Produces(value={"text/html", "application/xhtml+xml"})
public class TemplateMessageBodyWriter
implements MessageBodyWriter<String> {
    private static final String TPL_PREFIX = "tpl:";
    @Inject
    private TemplateEngine templateEngine;
    @Inject
    private ApplicationContext applicationContext;
    @Inject
    private I18n i18n;
    @Context
    private HttpServletRequest request;
    @Context
    private HttpServletResponse response;

    public boolean isWriteable(Class<?> type, Type t, Annotation[] annotations, MediaType mediaType) {
        return type.isAssignableFrom(String.class) && mediaType.isCompatible(MediaType.TEXT_HTML_TYPE);
    }

    public long getSize(String t, Class<?> type, Type type1, Annotation[] antns, MediaType mt) {
        return -1L;
    }

    public void writeTo(String t, Class<?> type, Type type1, Annotation[] antns, MediaType mt, MultivaluedMap<String, Object> mm, OutputStream out) throws IOException, WebApplicationException {
        if (t.startsWith(TPL_PREFIX)) {
            String templateName = t.replaceFirst(TPL_PREFIX, "");
            templateName = this.removeEndSlash(templateName);
            this.writeTemplate(templateName, new HashMap(), new OutputStreamWriter(out));
        } else {
            this.writeString(t, new OutputStreamWriter(out));
        }
    }

    private String removeEndSlash(String templateName) {
        if (templateName.endsWith("/")) {
            return templateName.substring(0, templateName.length() - 1);
        }
        return templateName;
    }

    private void writeString(String s, OutputStreamWriter writer) throws IOException {
        writer.write(s, 0, s.length());
        writer.flush();
    }

    private void writeTemplate(String name, Map<String, Object> model, OutputStreamWriter writer) throws IOException {
        model.put("currentUrl", this.getRealRequestUri(this.request));
        model.put("contextPath", this.request.getContextPath());
        Locale locale = this.setLocale(this.request);
        SpringWebContext context = new SpringWebContext(this.request, this.response, this.request.getSession().getServletContext(), locale, model, this.applicationContext);
        this.templateEngine.process(name, (IContext)context, (Writer)writer);
        writer.flush();
    }

    private String getRealRequestUri(HttpServletRequest request) {
        String uri = (String)request.getAttribute("javax.servlet.forward.request_uri");
        if (uri == null) {
            uri = request.getRequestURI();
        }
        return uri;
    }

    private Locale setLocale(HttpServletRequest request) {
        String langTag = this.getLangTag(request, request.getParameter("lang"));
        Locale locale = null;
        if (langTag != null && langTag.contains("-")) {
            String[] localeSplit = langTag.split("-");
            locale = new Locale(localeSplit[0], localeSplit[1]);
        } else {
            locale = langTag != null ? new Locale(langTag) : Locale.getDefault();
        }
        this.i18n.setLocale(locale);
        return locale;
    }

    private String getLangTag(HttpServletRequest request, String override) {
        if (override != null && override.equalsIgnoreCase("de")) {
            return "de-DE";
        }
        String langTag = null;
        if (override != null && override.contains("-")) {
            langTag = override;
        } else {
            if (request.getHeader("Accept-Language") == null) {
                return "de-DE";
            }
            try {
                langTag = request.getHeader("Accept-Language").split(";")[0].split(",")[0];
            }
            catch (Exception e) {
                langTag = "de-DE";
            }
        }
        return langTag;
    }
}

