/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cycle.web.service.resource;

import java.io.InputStream;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.camunda.bpm.cycle.connector.Connector;
import org.camunda.bpm.cycle.connector.ConnectorNode;
import org.camunda.bpm.cycle.connector.ConnectorNodeType;
import org.camunda.bpm.cycle.connector.ConnectorRegistry;
import org.camunda.bpm.cycle.connector.ContentInformation;
import org.camunda.bpm.cycle.connector.signavio.SignavioConnector;
import org.camunda.bpm.cycle.entity.AbstractEntity;
import org.camunda.bpm.cycle.entity.BpmnDiagram;
import org.camunda.bpm.cycle.entity.Roundtrip;
import org.camunda.bpm.cycle.exception.CycleException;
import org.camunda.bpm.cycle.repository.RoundtripRepository;
import org.camunda.bpm.cycle.roundtrip.SynchronizationService;
import org.camunda.bpm.cycle.util.IoUtil;
import org.camunda.bpm.cycle.web.dto.BpmnDiagramDTO;
import org.camunda.bpm.cycle.web.dto.ConnectorNodeDTO;
import org.camunda.bpm.cycle.web.dto.RoundtripDTO;
import org.camunda.bpm.cycle.web.dto.SynchronizationResultDTO;
import org.camunda.bpm.cycle.web.service.AbstractRestService;
import org.camunda.bpm.cycle.web.service.resource.BpmnDiagramService;
import org.camunda.bpm.cycle.web.service.resource.RoundtripService;
import org.springframework.transaction.annotation.Transactional;

@Path(value="secured/resource/roundtrip")
public class RoundtripService
extends AbstractRestService {
    @Inject
    private RoundtripRepository roundtripRepository;
    @Inject
    private ConnectorRegistry connectorRegistry;
    @Inject
    private BpmnDiagramService bpmnDiagramController;
    @Inject
    private SynchronizationService synchronizationService;

    @GET
    public List<RoundtripDTO> list() {
        return RoundtripDTO.wrapAll((List)this.roundtripRepository.findAll());
    }

    @GET
    @Path(value="{id}")
    public RoundtripDTO get(@PathParam(value="id") long id) {
        return RoundtripDTO.wrap((Roundtrip)((Roundtrip)this.roundtripRepository.findById(id)));
    }

    @POST
    @Path(value="{id}")
    @Transactional
    public RoundtripDTO update(RoundtripDTO data) {
        long id = data.getId();
        Roundtrip roundtrip = (Roundtrip)this.roundtripRepository.findById(id);
        if (roundtrip == null) {
            throw this.notFound("roundtrip not found");
        }
        this.update(roundtrip, data);
        return RoundtripDTO.wrap((Roundtrip)roundtrip);
    }

    @POST
    public RoundtripDTO create(RoundtripDTO data) {
        Roundtrip roundtrip = new Roundtrip();
        this.update(roundtrip, data);
        return RoundtripDTO.wrap((Roundtrip)((Roundtrip)this.roundtripRepository.saveAndFlush((AbstractEntity)roundtrip)));
    }

    @DELETE
    @Path(value="{id}")
    @Transactional
    public void delete(@PathParam(value="id") long id) {
        Roundtrip roundtrip = (Roundtrip)this.roundtripRepository.findById(id);
        if (roundtrip == null) {
            throw this.notFound("roundtrip not found");
        }
        this.roundtripRepository.delete((AbstractEntity)roundtrip);
    }

    @GET
    @Transactional
    @Path(value="{id}/details")
    public RoundtripDTO getDetails(@PathParam(value="id") long id) {
        Roundtrip roundtrip = (Roundtrip)this.roundtripRepository.findById(id);
        RoundtripDTO roundtripDTO = new RoundtripDTO(roundtrip);
        if (roundtrip.getLeftHandSide() != null) {
            roundtripDTO.setLeftHandSide(BpmnDiagramDTO.wrap((BpmnDiagram)roundtrip.getLeftHandSide()));
        } else {
            roundtripDTO.setLeftHandSide(null);
        }
        if (roundtrip.getRightHandSide() != null) {
            roundtripDTO.setRightHandSide(BpmnDiagramDTO.wrap((BpmnDiagram)roundtrip.getRightHandSide()));
        } else {
            roundtripDTO.setRightHandSide(null);
        }
        return roundtripDTO;
    }

    @POST
    @Path(value="{id}/details")
    @Transactional
    public RoundtripDTO updateDetails(RoundtripDTO data) {
        long id = data.getId();
        Roundtrip roundtrip = (Roundtrip)this.roundtripRepository.findById(id);
        if (roundtrip == null) {
            throw this.notFound("roundtrip not found");
        }
        if (data.getLeftHandSide() != null) {
            BpmnDiagramDTO leftHandSideDTO = data.getLeftHandSide();
            BpmnDiagram leftHandSide = this.bpmnDiagramController.createOrUpdate(leftHandSideDTO);
            roundtrip.setLeftHandSide(leftHandSide);
        } else {
            roundtrip.setLeftHandSide(null);
        }
        if (data.getRightHandSide() != null) {
            BpmnDiagramDTO rightHandSideDTO = data.getRightHandSide();
            BpmnDiagram rightHandSide = this.bpmnDiagramController.createOrUpdate(rightHandSideDTO);
            roundtrip.setRightHandSide(rightHandSide);
        } else {
            roundtrip.setRightHandSide(null);
        }
        Roundtrip saved = (Roundtrip)this.roundtripRepository.saveAndFlush((AbstractEntity)roundtrip);
        return new RoundtripDTO(saved, saved.getLeftHandSide(), saved.getRightHandSide());
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="isNameAvailable")
    public boolean isNameAvailable(@QueryParam(value="name") String name) {
        return this.roundtripRepository.isNameAvailable(name);
    }

    @POST
    @Path(value="{id}/sync")
    @Transactional
    public SynchronizationResultDTO doSynchronize(@QueryParam(value="syncMode") Roundtrip.SyncMode syncMode, @PathParam(value="id") long roundtripId, @QueryParam(value="message") String message) {
        try {
            Roundtrip roundtrip = (Roundtrip)this.roundtripRepository.findById(roundtripId);
            if (roundtrip == null) {
                throw this.notFound("roundtrip not found");
            }
            this.synchronizeModels(roundtrip.getLeftHandSide(), roundtrip.getRightHandSide(), syncMode, message);
            roundtrip.setLastSync(new Date());
            roundtrip.setLastSyncMode(syncMode);
            return new SynchronizationResultDTO(SynchronizationResultDTO.SynchronizationStatus.SYNC_SUCCESS);
        }
        catch (Exception e) {
            return new SynchronizationResultDTO(SynchronizationResultDTO.SynchronizationStatus.SYNC_FAILED, e.getMessage());
        }
    }

    @POST
    @Path(value="{id}/create")
    @Transactional
    public RoundtripDTO create(@PathParam(value="id") long roundtripId, @QueryParam(value="diagramlabel") String diagramLabel, @QueryParam(value="syncMode") Roundtrip.SyncMode syncMode, @QueryParam(value="modeler") String modeler, @QueryParam(value="connectorId") Long connectorId, @QueryParam(value="parentFolderId") String parentFolderId, @QueryParam(value="message") String message) {
        Roundtrip roundtrip = (Roundtrip)this.roundtripRepository.findById(roundtripId);
        if (roundtrip == null) {
            throw this.notFound("Roundtrip not found");
        }
        if (roundtrip.getLeftHandSide() == null && roundtrip.getRightHandSide() == null) {
            throw new CycleException("No model exists in roundtrip '" + roundtrip.getName() + "'. It is not possible to create a diagram model.");
        }
        Connector connector = this.connectorRegistry.getConnector(connectorId.longValue());
        if (!(connector instanceof SignavioConnector || diagramLabel.endsWith(".xml") || diagramLabel.endsWith(".bpmn"))) {
            diagramLabel = diagramLabel.concat(".bpmn");
        }
        BpmnDiagramDTO bpmnDiagramDTO = new BpmnDiagramDTO();
        bpmnDiagramDTO.setLabel(diagramLabel);
        bpmnDiagramDTO.setModeler(modeler);
        ConnectorNode newConnectorNode = connector.createNode(parentFolderId, diagramLabel, ConnectorNodeType.BPMN_FILE, message);
        bpmnDiagramDTO.setConnectorNode(new ConnectorNodeDTO(newConnectorNode));
        BpmnDiagram bpmnDiagram = this.bpmnDiagramController.createOrUpdate(bpmnDiagramDTO);
        bpmnDiagram.setConnectorId(connectorId);
        bpmnDiagram.setLastModified(new Date());
        switch (1.$SwitchMap$org$camunda$bpm$cycle$entity$Roundtrip$SyncMode[syncMode.ordinal()]) {
            case 1: {
                this.synchronizeModels(roundtrip.getLeftHandSide(), bpmnDiagram, Roundtrip.SyncMode.LEFT_TO_RIGHT, message);
                roundtrip.setRightHandSide(bpmnDiagram);
                break;
            }
            case 2: {
                ConnectorNode rhsNode = roundtrip.getRightHandSide().getConnectorNode();
                Connector rhsConnector = this.connectorRegistry.getConnector(rhsNode.getConnectorId().longValue());
                InputStream rhsInputStream = rhsConnector.getContent(rhsNode);
                try {
                    ContentInformation contentInformation = connector.updateContent(newConnectorNode, rhsInputStream, message);
                    bpmnDiagram.setLastSync(contentInformation.getLastModified());
                    IoUtil.closeSilently((InputStream)rhsInputStream);
                    ContentInformation otherSideInfo = rhsConnector.getContentInformation(rhsNode);
                    roundtrip.getRightHandSide().setLastSync(otherSideInfo.getLastModified());
                }
                catch (Exception e) {
                    throw new CycleException("Creation of left hand side model failed.", (Throwable)e);
                }
                roundtrip.setLeftHandSide(bpmnDiagram);
            }
        }
        roundtrip.setLastSync(new Date());
        roundtrip.setLastSyncMode(syncMode);
        RoundtripDTO roundtripDTO = RoundtripDTO.wrapIncludeDiagrams((Roundtrip)roundtrip);
        return roundtripDTO;
    }

    private void update(Roundtrip roundtrip, RoundtripDTO data) {
        roundtrip.setName(data.getName());
    }

    private void synchronizeModels(BpmnDiagram lhs, BpmnDiagram rhs, Roundtrip.SyncMode syncMode, String message) {
        if (lhs == null) {
            throw new IllegalArgumentException("Left hand side model is null");
        }
        if (rhs == null) {
            throw new IllegalArgumentException("Right hand side model is null");
        }
        ConnectorNode lhsNode = lhs.getConnectorNode();
        ConnectorNode rhsNode = rhs.getConnectorNode();
        Connector lhsConnector = this.connectorRegistry.getConnector(lhsNode.getConnectorId().longValue());
        Connector rhsConnector = this.connectorRegistry.getConnector(rhsNode.getConnectorId().longValue());
        InputStream lhsInputStream = lhsConnector.getContent(lhsNode);
        InputStream rhsInputStream = rhsConnector.getContent(rhsNode);
        try {
            InputStream resultStream = null;
            switch (1.$SwitchMap$org$camunda$bpm$cycle$entity$Roundtrip$SyncMode[syncMode.ordinal()]) {
                case 1: {
                    resultStream = this.synchronizationService.syncLeftToRight(lhsInputStream, rhsInputStream);
                    IoUtil.closeSilently((InputStream[])new InputStream[]{lhsInputStream, rhsInputStream});
                    ContentInformation resultInfo = rhsConnector.updateContent(rhsNode, resultStream, message);
                    rhs.setLastSync(resultInfo.getLastModified());
                    ContentInformation otherSideInfo = lhsConnector.getContentInformation(lhsNode);
                    lhs.setLastSync(otherSideInfo.getLastModified());
                    break;
                }
                case 2: {
                    resultStream = this.synchronizationService.syncRightToLeft(lhsInputStream, rhsInputStream);
                    IoUtil.closeSilently((InputStream[])new InputStream[]{lhsInputStream, rhsInputStream});
                    ContentInformation resultInfo = lhsConnector.updateContent(lhsNode, resultStream, message);
                    lhs.setLastSync(resultInfo.getLastModified());
                    ContentInformation otherSideInfo = rhsConnector.getContentInformation(rhsNode);
                    rhs.setLastSync(otherSideInfo.getLastModified());
                }
            }
            IoUtil.closeSilently(resultStream);
        }
        catch (Exception e) {
            if (e instanceof CycleException) {
                throw (CycleException)e;
            }
            throw new CycleException("Synchronization failed: " + e.getMessage(), (Throwable)e);
        }
    }
}

