/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.security.web;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.camunda.bpm.cycle.security.IdentityHolder;
import org.camunda.bpm.security.UserIdentity;
import org.camunda.bpm.security.service.SecurityService;
import org.camunda.bpm.security.web.SecurityWrappedRequest;
import org.camunda.bpm.security.web.util.WebUtil;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SecurityFilter
implements Filter {
    private static Logger log = Logger.getLogger(SecurityFilter.class.getName());
    private WebApplicationContext context;
    public static final String IDENTITY_SESSION_KEY = "org.camunda.bpm.SecurityFilter.SESSION_KEY";
    public static final String PRE_AUTHENTICATION_URL = "org.camunda.bpm.SecurityFilter.LAST_REQUEST_URI";
    static final String NOP = "NOP";

    public void init(FilterConfig config) throws ServletException {
        this.context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)config.getServletContext());
    }

    public void destroy() {
    }

    void setWebApplicationContext(WebApplicationContext context) {
        this.context = context;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doFilterSecure((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    void doFilterSecure(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        UserIdentity identity = this.getAuthenticatedIdentity(request);
        if (identity != null) {
            request = this.wrapAuthenticated(request, identity);
            IdentityHolder.setIdentity(null);
        } else {
            String uri = this.performSecurityCheck(request.getRequestURI(), request, response);
            if (uri != null) {
                if (uri.equals(NOP)) {
                    return;
                }
                boolean forward = false;
                if (uri.startsWith("forward:")) {
                    uri = uri.substring("forward:".length());
                    forward = true;
                }
                uri = uri.replace("app:", request.getContextPath() + "/");
                if (forward) {
                    request.getRequestDispatcher(uri).forward((ServletRequest)request, (ServletResponse)response);
                } else {
                    response.sendRedirect(uri);
                }
                return;
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    String performSecurityCheck(String requestUri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.requiresAuthentication(requestUri)) {
            if (WebUtil.isAjax((HttpServletRequest)request)) {
                response.sendError(401, "Authorization required");
                return NOP;
            }
            if (WebUtil.isGET((HttpServletRequest)request)) {
                request.getSession().setAttribute(PRE_AUTHENTICATION_URL, (Object)request.getRequestURI());
            }
            return "forward:/app/login";
        }
        if (this.isLoginRequest(request)) {
            try {
                if (this.login(request, response)) {
                    String preLoginUrl = (String)request.getSession().getAttribute(PRE_AUTHENTICATION_URL);
                    if (preLoginUrl != null) {
                        return preLoginUrl;
                    }
                    return "app:app/secured/view/index";
                }
                return "app:app/login/error";
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                return null;
            }
        }
        if (this.isLogoutRequest(request)) {
            this.logout(request);
            return "app:app/login/loggedOut";
        }
        return null;
    }

    protected UserIdentity getAuthenticatedIdentity(HttpServletRequest request) {
        return (UserIdentity)request.getSession().getAttribute(IDENTITY_SESSION_KEY);
    }

    protected void setAuthenticatedIdentity(HttpServletRequest request, UserIdentity identity) {
        request.getSession().setAttribute(IDENTITY_SESSION_KEY, (Object)identity);
    }

    protected boolean isLoginRequest(HttpServletRequest request) {
        return this.requestUriMatches(request, "j_security_check") && WebUtil.isPOST((HttpServletRequest)request);
    }

    private boolean isLogoutRequest(HttpServletRequest request) {
        return this.requestUriMatches(request, "app/login/logout");
    }

    protected boolean login(HttpServletRequest request, HttpServletResponse response) {
        String userName = request.getParameter("j_username");
        String password = request.getParameter("j_password");
        if (userName == null || password == null) {
            return false;
        }
        SecurityService securityService = (SecurityService)this.context.getBean(SecurityService.class);
        UserIdentity identity = securityService.login(userName, password);
        if (identity != null) {
            this.setAuthenticatedIdentity(request, identity);
            return true;
        }
        return false;
    }

    private void logout(HttpServletRequest request) {
        request.getSession().invalidate();
    }

    private boolean requiresAuthentication(String uri) {
        return uri.matches(".*/app/secured/.*");
    }

    private HttpServletRequest wrapAuthenticated(HttpServletRequest request, UserIdentity identity) {
        return new SecurityWrappedRequest(request, identity);
    }

    private boolean requestUriMatches(HttpServletRequest request, String uri) {
        return request.getRequestURI().matches(request.getContextPath() + "/" + uri);
    }
}

